/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.Component;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.filechooser.FileSystemView;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.praxislive.core.Value;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PMap;
import org.praxislive.ide.pxr.Bundle;
import org.praxislive.ide.pxr.PXGExportWizardPanel1;
import org.praxislive.project.GraphElement;
import org.praxislive.project.GraphModel;
import org.praxislive.project.SyntaxUtils;

final class PXGExportWizard {
    static final String KEY_FILE = "file";
    static final String KEY_PALETTE_CATEGORY = "palette-category";
    static final String KEY_LIBRARIES = "libraries";
    static final String KEY_SHARED_CODE = "shared-code";
    private final GraphModel model;
    private final PArray libs;
    private final PMap sharedCode;
    private final String suggestedFileName;
    private final String suggestedPaletteCategory;
    private GraphModel exportModel;
    private File exportFile;
    private String paletteCategory;

    PXGExportWizard(GraphModel model, PArray libs, PMap sharedCode) {
        this.model = model;
        this.libs = (PArray)libs.stream().filter(lib -> lib.toString().startsWith("pkg:")).collect(PArray.collector());
        this.sharedCode = sharedCode;
        this.suggestedFileName = this.findSuggestedName(model.root());
        this.suggestedPaletteCategory = this.findPaletteCategory(model.root());
    }

    Object display() {
        ArrayList<PXGExportWizardPanel1> panels = new ArrayList<PXGExportWizardPanel1>();
        panels.add(new PXGExportWizardPanel1(this));
        String[] steps = new String[panels.size()];
        for (int i = 0; i < panels.size(); ++i) {
            Component c = ((WizardDescriptor.Panel)panels.get(i)).getComponent();
            steps[i] = c.getName();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", true);
            jc.putClientProperty("WizardPanel_contentDisplayed", true);
            jc.putClientProperty("WizardPanel_contentNumbered", true);
        }
        WizardDescriptor wiz = new WizardDescriptor((WizardDescriptor.Iterator)new WizardDescriptor.ArrayIterator(panels));
        wiz.setTitleFormat(new MessageFormat("{0}"));
        wiz.setTitle(Bundle.PXGExportWizard_title());
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)wiz);
        if (ret == WizardDescriptor.FINISH_OPTION) {
            this.exportFile = (File)wiz.getProperty(KEY_FILE);
            this.paletteCategory = (String)wiz.getProperty(KEY_PALETTE_CATEGORY);
            boolean addLibs = (Boolean)wiz.getProperty(KEY_LIBRARIES);
            boolean addSharedCode = (Boolean)wiz.getProperty(KEY_SHARED_CODE);
            this.exportModel = addLibs || addSharedCode ? this.model.withTransform(root -> {
                if (!this.libs.isEmpty()) {
                    root.command("$LIBRARIES " + SyntaxUtils.valueToToken((Value)this.libs));
                }
                if (!this.sharedCode.isEmpty()) {
                    root.command("$SHARED_CODE " + SyntaxUtils.valueToToken((Value)this.sharedCode));
                }
            }) : this.model;
        } else {
            this.exportFile = null;
            this.paletteCategory = null;
        }
        return ret;
    }

    File getExportFile() {
        return this.exportFile;
    }

    GraphModel getExportModel() {
        return this.exportModel;
    }

    String getPaletteCategory() {
        return this.paletteCategory;
    }

    String getSuggestedFileName() {
        return this.suggestedFileName;
    }

    String getSuggestedPaletteCategory() {
        return this.suggestedPaletteCategory;
    }

    boolean hasLibraries() {
        return !this.libs.isEmpty();
    }

    boolean hasSharedCode() {
        return !this.sharedCode.isEmpty();
    }

    boolean mightUseLibraries() {
        return this.hasLibraries();
    }

    boolean mightUseSharedCode() {
        return this.hasSharedCode();
    }

    File getDefaultLocation() {
        File location = FileSystemView.getFileSystemView().getDefaultDirectory();
        if (location != null) {
            try {
                String[] path;
                for (String dir : path = Bundle.PXGExportWizard_defaultLocation().split("/")) {
                    File d = new File(location, dir);
                    if (d.exists()) {
                        if (!d.isDirectory() || !d.canWrite()) break;
                        location = d;
                        continue;
                    }
                    if (!d.mkdir()) break;
                    location = d;
                }
                return location;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return FileUtil.normalizeFile((File)new File(System.getProperty("user.home")));
    }

    private String findSuggestedName(GraphElement.Root root) {
        if (root.children().size() == 1) {
            return (String)root.children().firstEntry().getKey();
        }
        return "";
    }

    private String findPaletteCategory(GraphElement.Root root) {
        Object ret = "core:custom";
        for (GraphElement.Component cmp : root.children().sequencedValues()) {
            if (!cmp.children().isEmpty()) {
                return "";
            }
            String type = cmp.type().toString();
            if (type.startsWith("video:gl:")) {
                return "video:gl:custom";
            }
            if (type.startsWith("core")) continue;
            String base = type.substring(0, type.indexOf(":"));
            ret = base + ":custom";
        }
        return ret;
    }
}

