/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.io.File;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.praxislive.core.ComponentType;
import org.praxislive.ide.pxr.Bundle;
import org.praxislive.ide.pxr.PXGExportVisualPanel1;
import org.praxislive.ide.pxr.PXGExportWizard;

class PXGExportWizardPanel1
implements WizardDescriptor.Panel<WizardDescriptor> {
    private final ChangeSupport cs;
    private final PXGExportWizard exporter;
    private PXGExportVisualPanel1 component;
    private boolean valid;
    private WizardDescriptor wiz;
    private File file;
    private String paletteCategory;
    private boolean includeLibs;
    private boolean includeSharedCode;

    PXGExportWizardPanel1(PXGExportWizard exporter) {
        this.exporter = exporter;
        this.cs = new ChangeSupport((Object)this);
    }

    public PXGExportVisualPanel1 getComponent() {
        if (this.component == null) {
            this.component = new PXGExportVisualPanel1(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    public void readSettings(WizardDescriptor wiz) {
        this.wiz = wiz;
    }

    public void storeSettings(WizardDescriptor wiz) {
        wiz.putProperty("file", (Object)this.file);
        wiz.putProperty("palette-category", (Object)this.paletteCategory);
        wiz.putProperty("libraries", (Object)this.includeLibs);
        wiz.putProperty("shared-code", (Object)this.includeSharedCode);
    }

    PXGExportWizard getWizard() {
        return this.exporter;
    }

    void validate() {
        Object f;
        if (this.component == null) {
            return;
        }
        boolean nowValid = false;
        this.file = null;
        this.paletteCategory = null;
        File loc = this.component.getFileLocation();
        String err = null;
        Object name = this.component.getFileName();
        if (!((String)name).isEmpty()) {
            if (loc == null || !loc.isDirectory() || !loc.canWrite()) {
                err = Bundle.PXGExportWizard_nonWritableDirectory();
            } else {
                if (!((String)name).endsWith(".pxg")) {
                    name = (String)name + ".pxg";
                }
                if (((File)(f = new File(loc, (String)name))).exists()) {
                    err = Bundle.PXGExportWizard_fileExists();
                } else {
                    this.file = f;
                    nowValid = true;
                }
            }
        }
        this.paletteCategory = this.component.getPaletteCategory().trim();
        if (!this.paletteCategory.isEmpty()) {
            try {
                f = ComponentType.of((String)(this.paletteCategory + ":test"));
            }
            catch (Exception ex) {
                err = Bundle.PXGExportWizard_invalidPaletteCategory();
                nowValid = false;
            }
        }
        this.includeLibs = this.component.includeLibraries();
        this.includeSharedCode = this.component.includeSharedCode();
        this.wiz.putProperty("WizardPanel_errorMessage", (Object)err);
        this.valid = nowValid;
        this.cs.fireChange();
    }
}

