/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.Component;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Objects;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.praxislive.core.ComponentAddress;
import org.praxislive.ide.pxr.Bundle;
import org.praxislive.ide.pxr.PXRVisualPanel1;

final class PXRWizardPanel1
implements WizardDescriptor.Panel<WizardDescriptor> {
    private final ChangeSupport cs;
    private final FileObject projectDir;
    private final FileObject templateFile;
    private PXRVisualPanel1 component;
    private boolean valid;
    private WizardDescriptor wizard;
    private String id;

    PXRWizardPanel1(FileObject projectDir, FileObject templateFile) {
        this.projectDir = Objects.requireNonNull(projectDir);
        this.templateFile = Objects.requireNonNull(templateFile);
        this.cs = new ChangeSupport((Object)this);
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new PXRVisualPanel1(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        return this.valid;
    }

    public final void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    void validate() {
        boolean nowValid = false;
        this.id = null;
        String err = null;
        String name = this.component.getRootID();
        if (!this.isValidName(name)) {
            err = Bundle.ERR_InvalidRootID();
        } else if (Files.exists(FileUtil.toPath((FileObject)this.projectDir).resolve(name + ".pxr"), new LinkOption[0])) {
            err = Bundle.ERR_RootFileExists();
        } else {
            this.id = name;
            nowValid = true;
        }
        if (nowValid != this.valid) {
            this.valid = nowValid;
            this.cs.fireChange();
        }
        if (this.wizard != null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)err);
        }
    }

    private boolean isValidName(String name) {
        if (name == null || name.isEmpty() || name.strip().isEmpty()) {
            return false;
        }
        return ComponentAddress.isValidID((String)name);
    }

    FileObject getTemplateFile() {
        return this.templateFile;
    }

    FileObject getProjectDir() {
        return this.projectDir;
    }

    public void readSettings(WizardDescriptor settings) {
        this.wizard = settings;
    }

    public void storeSettings(WizardDescriptor settings) {
        if (settings == this.wizard) {
            this.wizard.putProperty("PXR.id", (Object)this.id);
        }
    }
}

