/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.CloseButtonFactory;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Connection;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.PortInfo;
import org.praxislive.ide.model.ComponentProxy;
import org.praxislive.ide.model.ProxyException;
import org.praxislive.ide.pxr.ActionEditorContext;
import org.praxislive.ide.pxr.Bundle;
import org.praxislive.ide.pxr.JSuggestField;
import org.praxislive.ide.pxr.PXRComponentProxy;
import org.praxislive.ide.pxr.PXRContainerProxy;
import org.praxislive.ide.pxr.spi.RootEditor;

class ToolActions {
    private final ActionEditorContext editor;
    private final JPanel actionPanel;
    private final Set<RootEditor.ToolAction> supportedActions;

    ToolActions(ActionEditorContext editor, Set<RootEditor.ToolAction> supportedActions) {
        this.editor = editor;
        this.supportedActions = Set.copyOf(supportedActions);
        this.actionPanel = new JPanel(new BorderLayout());
    }

    JPanel getActionPanel() {
        return this.actionPanel;
    }

    void installActions(InputMap im, ActionMap am) {
        for (RootEditor.ToolAction action : this.supportedActions) {
            switch (action) {
                case ADD: {
                    im.put(KeyStroke.getKeyStroke("typed @"), "add-component");
                    am.put("add-component", new Add());
                    break;
                }
                case SELECT: {
                    im.put(KeyStroke.getKeyStroke("typed /"), "select");
                    am.put("select", new Select());
                    break;
                }
                case CALL: {
                    im.put(KeyStroke.getKeyStroke("typed ."), "call");
                    am.put("call", new Call());
                    break;
                }
                case CONNECT: {
                    im.put(KeyStroke.getKeyStroke("typed ~"), "connect");
                    am.put("connect", new Connect(false));
                    break;
                }
                case DISCONNECT: {
                    im.put(KeyStroke.getKeyStroke("typed !"), "disconnect");
                    am.put("disconnect", new Connect(true));
                }
            }
        }
    }

    private void installToActionPanel(JComponent component) {
        this.actionPanel.add(component);
        this.actionPanel.revalidate();
    }

    private void clearActionPanel() {
        this.actionPanel.removeAll();
        this.actionPanel.revalidate();
        this.editor.editor().requestFocus();
    }

    private List<PXRComponentProxy> findMatchingComponents(String glob) {
        PXRContainerProxy container = this.editor.context();
        if (glob.isEmpty() || glob.equals(Bundle.TXT_Parent())) {
            return List.of(container);
        }
        try {
            Pattern search = ToolActions.globToRegex(glob);
            return container.children().filter(id -> search.matcher((CharSequence)id).matches()).map(id -> container.getChild((String)id)).toList();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return List.of();
        }
    }

    private static Pattern globToRegex(String glob) {
        StringBuilder regex = new StringBuilder();
        block7: for (char c : glob.toCharArray()) {
            switch (c) {
                case '*': {
                    regex.append(".*");
                    continue block7;
                }
                case '?': {
                    regex.append('.');
                    continue block7;
                }
                case '|': {
                    regex.append('|');
                    continue block7;
                }
                case '_': {
                    regex.append('_');
                    continue block7;
                }
                case '-': {
                    regex.append("\\-");
                    continue block7;
                }
                default: {
                    if (Character.isJavaIdentifierPart(c)) {
                        regex.append(c);
                        continue block7;
                    }
                    throw new IllegalArgumentException();
                }
            }
        }
        return Pattern.compile(regex.toString());
    }

    private static String selectionToGlob(List<PXRComponentProxy> selection) {
        return selection.stream().map(ComponentProxy::getID).collect(Collectors.joining("|"));
    }

    class Add
    extends AbstractAction {
        private final Map<String, Object> typeMap = new LinkedHashMap<String, Object>();
        private final List<String> suggestedTypes = new ArrayList<String>();

        Add() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Display panel = new Display();
            this.buildTypeMap();
            panel.typeField.setSuggestData(this.suggestedTypes);
            ToolActions.this.installToActionPanel(panel);
            panel.typeField.requestFocusInWindow();
        }

        private void completeAdd(String text) {
            if ((text = text.trim()).isEmpty()) {
                return;
            }
            Object obj = this.typeMap.get(text);
            if (obj == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ERR_UnknownType(), 0));
                return;
            }
            ToolActions.this.clearActionPanel();
            if (obj instanceof ComponentType) {
                ComponentType type = (ComponentType)obj;
                ToolActions.this.editor.acceptComponentType(type);
            } else {
                ToolActions.this.editor.acceptImport((FileObject)obj);
            }
        }

        private void buildTypeMap() {
            this.typeMap.clear();
            this.suggestedTypes.clear();
            Node paletteRoot = ToolActions.this.editor.palette();
            Stream.of(paletteRoot.getChildren().getNodes(true)).flatMap(category -> Stream.of(category.getChildren().getNodes(true))).forEachOrdered(item -> {
                ComponentType type = (ComponentType)item.getLookup().lookup(ComponentType.class);
                if (type != null) {
                    this.typeMap.put(type.toString(), type);
                } else {
                    FileObject file = (FileObject)item.getLookup().lookup(FileObject.class);
                    if (file != null) {
                        this.typeMap.put(item.getDisplayName(), file);
                    }
                }
            });
            this.suggestedTypes.addAll(this.typeMap.keySet());
        }

        class Display
        extends ActionDisplay {
            private final JSuggestField typeField;

            Display() {
                this.add(new JLabel(Bundle.LBL_AddAction()));
                this.addPadding();
                this.typeField = new JSuggestField();
                this.typeField.setColumns(24);
                this.typeField.setMaximumSize(this.typeField.getPreferredSize());
                this.add(this.typeField);
                this.typeField.addActionListener(e -> {
                    Add.this.completeAdd(this.typeField.getText());
                    ToolActions.this.clearActionPanel();
                });
                this.appendClose();
            }
        }
    }

    class Select
    extends AbstractAction {
        Select() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Display panel = new Display();
            ArrayList<String> components = new ArrayList<String>(ToolActions.this.editor.context().children().toList());
            components.sort(Comparator.naturalOrder());
            panel.idField.setSuggestData(components);
            ToolActions.this.installToActionPanel(panel);
            panel.idField.requestFocusInWindow();
        }

        private void completeSelection(String text) {
            if (text.isEmpty()) {
                ToolActions.this.editor.select(ToolActions.this.editor.context(), List.of());
                return;
            }
            Pattern search = ToolActions.globToRegex(text);
            PXRContainerProxy container = ToolActions.this.editor.context();
            List<PXRComponentProxy> selection = container.children().filter(id -> search.matcher((CharSequence)id).matches()).map(container::getChild).toList();
            ToolActions.this.editor.select(container, selection);
        }

        class Display
        extends ActionDisplay {
            private JSuggestField idField;

            Display() {
                this.add(new JLabel(Bundle.LBL_SelectAction()));
                this.addPadding();
                this.idField = new JSuggestField();
                this.idField.setColumns(18);
                this.idField.setMaximumSize(this.idField.getPreferredSize());
                this.add(this.idField);
                this.idField.addActionListener(e -> {
                    Select.this.completeSelection(this.idField.getText());
                    ToolActions.this.clearActionPanel();
                });
                this.appendClose();
            }
        }
    }

    class Call
    extends AbstractAction {
        Call() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Display panel = new Display();
            PXRContainerProxy container = ToolActions.this.editor.context();
            List<PXRComponentProxy> selection = ToolActions.this.editor.selection();
            ArrayList<String> components = new ArrayList<String>(container.children().toList());
            components.sort(Comparator.naturalOrder());
            panel.componentField.setSuggestData(components);
            ToolActions.this.installToActionPanel(panel);
            if (selection.isEmpty() || selection.get(0) == container) {
                panel.componentField.setText(Bundle.TXT_Parent());
                panel.componentField.selectAll();
                panel.componentField.requestFocusInWindow();
            } else {
                panel.componentField.setText(ToolActions.selectionToGlob(selection));
                panel.commitComponent(selection);
            }
        }

        private void findProperties(List<PXRComponentProxy> components, Set<String> names) {
            HashSet<Node.Property> result = new HashSet<Node.Property>();
            for (Node.PropertySet propertySet : components.get(0).getNodeDelegate().getPropertySets()) {
                for (Node.Property property : propertySet.getProperties()) {
                    if (!property.canWrite() || property.isHidden()) continue;
                    result.add(property);
                }
            }
            if (components.size() > 1) {
                HashSet<Node.Property> working = new HashSet<Node.Property>();
                for (int i = 1; i < components.size(); ++i) {
                    for (Node.PropertySet propertySet : components.get(i).getNodeDelegate().getPropertySets()) {
                        for (Node.Property property : propertySet.getProperties()) {
                            if (!property.canWrite() || property.isHidden()) continue;
                            working.add(property);
                        }
                    }
                    result.retainAll(working);
                    working.clear();
                    if (result.isEmpty()) break;
                }
            }
            for (Node.Property property : result) {
                names.add(property.getName());
            }
        }

        private void findActions(List<PXRComponentProxy> components, Set<String> names) {
            HashSet<String> result = new HashSet<String>();
            ComponentInfo info = components.get(0).getInfo();
            for (String id : info.controls()) {
                if (info.controlInfo(id).controlType() != ControlInfo.Type.Action) continue;
                result.add(id);
            }
            if (components.size() > 1) {
                HashSet<String> working = new HashSet<String>();
                for (int i = 1; i < components.size(); ++i) {
                    info = components.get(i).getInfo();
                    for (String id : info.controls()) {
                        if (info.controlInfo(id).controlType() != ControlInfo.Type.Action) continue;
                        working.add(id);
                    }
                    result.retainAll(working);
                    working.clear();
                    if (result.isEmpty()) break;
                }
            }
            names.addAll(result);
        }

        private Node.Property<?> findProperty(String componentGlob, String name) {
            List<PXRComponentProxy> cmps = ToolActions.this.findMatchingComponents(componentGlob);
            if (cmps.isEmpty()) {
                return null;
            }
            return this.findProperty(cmps.get(0), name);
        }

        private Node.Property<?> findProperty(PXRComponentProxy cmp, String name) {
            for (Node.PropertySet set : cmp.getNodeDelegate().getPropertySets()) {
                for (Node.Property property : set.getProperties()) {
                    if (!property.getName().equals(name) || !property.canWrite() || property.isHidden()) continue;
                    return property;
                }
            }
            return null;
        }

        private Action findAction(String componentGlob, String controlID) {
            List<PXRComponentProxy> cmps = ToolActions.this.findMatchingComponents(componentGlob);
            for (PXRComponentProxy cmp : cmps) {
                for (Action action : cmp.getNodeDelegate().getActions(false)) {
                    if (action == null || !controlID.equals(action.getValue("Name"))) continue;
                    return action;
                }
            }
            return null;
        }

        private void invokePropertyChange(String componentGlob, String controlID, String value) throws Exception {
            List<PXRComponentProxy> cmps = ToolActions.this.findMatchingComponents(componentGlob);
            for (PXRComponentProxy cmp : cmps) {
                Node.Property<?> property = this.findProperty(cmp, controlID);
                if (property == null) continue;
                PropertyEditor pe = property.getPropertyEditor();
                pe.setAsText(value);
                property.setValue(pe.getValue());
            }
        }

        private void invokeCustomPropertyEditor(String componentGlob, String controlID) {
            List<PXRComponentProxy> cmps = ToolActions.this.findMatchingComponents(componentGlob);
            if (cmps.isEmpty()) {
                return;
            }
            try {
                Node.Property<?> property = this.findProperty(cmps.get(0), controlID);
                if (property != null) {
                    PropertyPanel panel = new PropertyPanel(property, 2);
                    panel.setChangeImmediate(false);
                    DialogDescriptor descriptor = new DialogDescriptor((Object)panel, property.getDisplayName(), true, e -> {
                        if (e.getSource() == DialogDescriptor.OK_OPTION) {
                            panel.updateValue();
                        }
                    });
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == DialogDescriptor.OK_OPTION) {
                        Object value = property.getValue();
                        for (PXRComponentProxy cmp : cmps) {
                            Node.Property<?> nodeProperty = this.findProperty(cmp, property.getName());
                            if (nodeProperty == property || nodeProperty == null) continue;
                            nodeProperty.setValue(value);
                        }
                    }
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        class Display
        extends ActionDisplay {
            private final JSuggestField componentField;
            private final JSuggestField controlField;
            private final JSuggestField valueField;

            Display() {
                this.add(new JLabel(Bundle.LBL_CallAction()));
                this.addPadding();
                this.componentField = new JSuggestField();
                this.componentField.setColumns(18);
                this.componentField.setMaximumSize(this.componentField.getPreferredSize());
                this.configureFocusActionKeys(this.componentField, false);
                this.add(this.componentField);
                this.addPadding();
                this.controlField = new JSuggestField();
                this.controlField.setEnabled(false);
                this.controlField.setColumns(18);
                this.controlField.setMaximumSize(this.controlField.getPreferredSize());
                this.configureFocusActionKeys(this.controlField, false);
                this.add(this.controlField);
                this.addPadding();
                this.valueField = new JSuggestField();
                this.valueField.setEnabled(false);
                this.valueField.setColumns(18);
                this.valueField.setFocusTraversalKeys(0, Collections.EMPTY_SET);
                this.add(this.valueField);
                this.componentField.addActionListener(this::commitComponent);
                this.controlField.addActionListener(this::commitControl);
                this.valueField.addActionListener(this::commitValue);
                this.appendClose();
            }

            private void commitComponent(ActionEvent e) {
                List<PXRComponentProxy> cmps = ToolActions.this.findMatchingComponents(this.componentField.getText());
                if (cmps.isEmpty()) {
                    return;
                }
                this.commitComponent(cmps);
            }

            private void commitComponent(List<PXRComponentProxy> cmps) {
                HashSet<String> ids = new HashSet<String>();
                Call.this.findProperties(cmps, ids);
                Call.this.findActions(cmps, ids);
                ArrayList<String> data = new ArrayList<String>(ids);
                data.sort(Comparator.naturalOrder());
                this.controlField.setSuggestData(data);
                this.controlField.setEnabled(true);
                this.controlField.requestFocusInWindow();
            }

            private void commitControl(ActionEvent e) {
                String controlID = this.controlField.getText();
                if (controlID.isEmpty()) {
                    return;
                }
                String componentGlob = this.componentField.getText();
                Action action = Call.this.findAction(componentGlob, controlID);
                if (action != null) {
                    try {
                        action.actionPerformed(e);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    ToolActions.this.clearActionPanel();
                    return;
                }
                Node.Property<?> property = Call.this.findProperty(componentGlob, controlID);
                if (property != null) {
                    PropertyEditor propEd = property.getPropertyEditor();
                    String valueText = propEd.getAsText();
                    String[] tags = propEd.getTags();
                    if (valueText != null) {
                        this.valueField.setEnabled(true);
                        this.valueField.setText(valueText);
                        if (tags != null && tags.length > 0) {
                            this.valueField.setSuggestData(List.of(tags));
                        } else {
                            this.valueField.setSuggestData(List.of());
                        }
                        this.valueField.selectAll();
                        this.valueField.requestFocusInWindow();
                    } else {
                        Call.this.invokeCustomPropertyEditor(componentGlob, controlID);
                        ToolActions.this.clearActionPanel();
                    }
                }
            }

            private void commitValue(ActionEvent e) {
                String controlID = this.controlField.getText();
                if (controlID.isEmpty()) {
                    ToolActions.this.clearActionPanel();
                    return;
                }
                String value = this.valueField.getText();
                try {
                    Call.this.invokePropertyChange(this.componentField.getText(), controlID, value);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                ToolActions.this.clearActionPanel();
            }
        }
    }

    class Connect
    extends AbstractAction {
        private final boolean disconnect;

        Connect(boolean disconnect) {
            this.disconnect = disconnect;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Display panel = new Display();
            ArrayList<String> childIDs = new ArrayList<String>(ToolActions.this.editor.context().children().toList());
            childIDs.sort(Comparator.naturalOrder());
            panel.srcField.setSuggestData(childIDs);
            panel.dstField.setSuggestData(childIDs);
            ToolActions.this.installToActionPanel(panel);
            List<PXRComponentProxy> selection = ToolActions.this.editor.selection();
            if (selection.isEmpty() || selection.get(0) == ToolActions.this.editor.context()) {
                panel.srcField.requestFocusInWindow();
            } else {
                panel.srcField.setText(ToolActions.selectionToGlob(selection));
                panel.commitSrc();
            }
        }

        private List<String> findPorts(List<PXRComponentProxy> components, boolean output) {
            PortInfo.Direction direction = output ? PortInfo.Direction.OUT : PortInfo.Direction.IN;
            return components.stream().map(PXRComponentProxy::getInfo).flatMap(info -> info.ports().stream().filter(pid -> info.portInfo(pid).direction() == direction)).distinct().toList();
        }

        private List<String> findPorts(List<PXRComponentProxy> components, String glob, boolean output) {
            PortInfo.Direction direction = output ? PortInfo.Direction.OUT : PortInfo.Direction.IN;
            try {
                Pattern search = ToolActions.globToRegex(glob);
                return components.stream().map(PXRComponentProxy::getInfo).flatMap(info -> info.ports().stream().filter(pid -> info.portInfo(pid).direction() == direction)).filter(id -> search.matcher((CharSequence)id).matches()).distinct().toList();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return List.of();
            }
        }

        private void makeConnections(String src, String srcPort, String dst, String dstPort) throws ProxyException {
            List<Connection> connections = this.possibleConnections(src, srcPort, dst, dstPort, true);
            for (Connection connection : connections) {
                ToolActions.this.editor.context().connect(connection);
            }
        }

        private void breakConnections(String src, String srcPort, String dst, String dstPort) throws ProxyException {
            List<Connection> connections = this.possibleConnections(src, srcPort, dst, dstPort, false);
            for (Connection connection : connections) {
                ToolActions.this.editor.context().disconnect(connection);
            }
        }

        private List<Connection> possibleConnections(String src, String srcPort, String dst, String dstPort, boolean interleave) {
            record PortRef(String component, String port) {
            }
            List sources = ToolActions.this.findMatchingComponents(src).stream().flatMap(cmp -> {
                String cmpID = cmp.getID();
                return this.findPorts(List.of(cmp), srcPort, true).stream().map(port -> new PortRef(cmpID, (String)port));
            }).toList();
            if (sources.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            List destinations = ToolActions.this.findMatchingComponents(dst).stream().flatMap(cmp -> {
                String cmpID = cmp.getID();
                return this.findPorts(List.of(cmp), dstPort, false).stream().map(port -> new PortRef(cmpID, (String)port));
            }).toList();
            if (destinations.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            if (interleave && sources.size() > 1 && destinations.size() > 1) {
                int srcSz = sources.size();
                int dstSz = destinations.size();
                return IntStream.range(0, Math.max(srcSz, dstSz)).mapToObj(i -> {
                    PortRef s = (PortRef)sources.get(i % srcSz);
                    PortRef d = (PortRef)destinations.get(i % dstSz);
                    return Connection.of((String)s.component(), (String)s.port(), (String)d.component(), (String)d.port());
                }).toList();
            }
            return sources.stream().flatMap(s -> destinations.stream().map(d -> Connection.of((String)s.component(), (String)s.port(), (String)d.component(), (String)d.port()))).toList();
        }

        class Display
        extends ActionDisplay {
            private final JSuggestField srcField;
            private final JSuggestField srcPortField;
            private final JSuggestField dstField;
            private final JSuggestField dstPortField;

            Display() {
                this.add(new JLabel(Connect.this.disconnect ? Bundle.LBL_DisconnectAction() : Bundle.LBL_ConnectAction()));
                this.addPadding();
                this.srcField = new JSuggestField();
                this.configureFocusActionKeys(this.srcField, false);
                this.srcField.setColumns(12);
                this.add(this.srcField);
                this.addPadding();
                this.srcPortField = new JSuggestField();
                this.configureFocusActionKeys(this.srcPortField, false);
                this.srcPortField.setColumns(12);
                this.srcPortField.setEnabled(false);
                this.add(this.srcPortField);
                this.addPadding();
                this.dstField = new JSuggestField();
                this.configureFocusActionKeys(this.dstField, false);
                this.dstField.setColumns(12);
                this.dstField.setEnabled(false);
                this.add(this.dstField);
                this.addPadding();
                this.dstPortField = new JSuggestField();
                this.configureFocusActionKeys(this.dstPortField, true);
                this.dstPortField.setColumns(12);
                this.dstPortField.setEnabled(false);
                this.add(this.dstPortField);
                this.addPadding();
                this.srcField.addActionListener(this::commitSrc);
                this.srcPortField.addActionListener(this::commitSrcPort);
                this.dstField.addActionListener(this::commitDst);
                this.dstPortField.addActionListener(this::commitDstPort);
                this.appendClose();
            }

            private void commitSrc(ActionEvent e) {
                this.commitSrc();
            }

            private void commitSrc() {
                String srcID = this.srcField.getText();
                if (srcID.isEmpty()) {
                    return;
                }
                this.srcPortField.setEnabled(true);
                List<String> ports = Connect.this.findPorts(ToolActions.this.findMatchingComponents(srcID), true);
                this.srcPortField.setSuggestData(ports);
                if (ports.size() == 1) {
                    this.srcPortField.setText(ports.get(0));
                    this.srcPortField.selectAll();
                }
                this.srcPortField.requestFocusInWindow();
            }

            private void commitSrcPort(ActionEvent e) {
                String portID = this.srcPortField.getText();
                if (portID.isEmpty()) {
                    return;
                }
                this.dstField.setEnabled(true);
                if (Connect.this.disconnect) {
                    this.dstField.setText("*");
                    this.dstField.selectAll();
                }
                this.dstField.requestFocusInWindow();
            }

            private void commitDst(ActionEvent e) {
                String dstID = this.dstField.getText();
                if (dstID.isEmpty()) {
                    return;
                }
                this.dstPortField.setEnabled(true);
                List<String> ports = Connect.this.findPorts(ToolActions.this.findMatchingComponents(dstID), false);
                if (ports.size() == 1) {
                    this.dstPortField.setText(ports.get(0));
                    this.dstPortField.selectAll();
                } else if (Connect.this.disconnect) {
                    this.dstPortField.setText("*");
                    this.dstPortField.selectAll();
                }
                this.dstPortField.setSuggestData(ports);
                this.dstPortField.requestFocusInWindow();
            }

            private void commitDstPort(ActionEvent e) {
                String portID = this.dstPortField.getText();
                if (portID.isEmpty()) {
                    return;
                }
                try {
                    if (Connect.this.disconnect) {
                        Connect.this.breakConnections(this.srcField.getText(), this.srcPortField.getText(), this.dstField.getText(), portID);
                    } else {
                        Connect.this.makeConnections(this.srcField.getText(), this.srcPortField.getText(), this.dstField.getText(), portID);
                    }
                }
                catch (ProxyException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                ToolActions.this.clearActionPanel();
            }
        }
    }

    private abstract class ActionDisplay
    extends JPanel {
        private ActionDisplay() {
            this.setLayout(new BoxLayout(this, 2));
            this.setFocusCycleRoot(true);
            this.addPadding();
        }

        final void appendClose() {
            AbstractAction close = new AbstractAction("close"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ToolActions.this.clearActionPanel();
                }
            };
            JButton closeButton = CloseButtonFactory.createBigCloseButton();
            closeButton.addActionListener(close);
            InputMap im = this.getInputMap(1);
            im.put(KeyStroke.getKeyStroke(27, 0, true), "close");
            ActionMap am = this.getActionMap();
            am.put("close", close);
            this.add(Box.createGlue());
            this.addPadding();
            this.add(closeButton);
        }

        final void addPadding() {
            this.add(Box.createHorizontalStrut(8));
        }

        final void configureFocusActionKeys(final JTextField textField, boolean primary) {
            if (!primary) {
                textField.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "notify-field-accept");
                textField.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "notify-field-accept");
            }
            textField.setFocusTraversalKeys(0, Collections.EMPTY_SET);
            textField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    textField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            });
        }
    }
}

