/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;
import org.praxislive.core.Value;
import org.praxislive.core.ValueFormatException;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PNumber;
import org.praxislive.core.types.PString;
import org.praxislive.ide.pxr.editors.ArrayTable;

class ArrayCustomEditor
extends JPanel
implements PropertyChangeListener {
    private final PropertyEditor editor;
    private final PropertyEnv env;
    boolean ignore;
    private JTable arrayTable;
    private JScrollPane scrollPane;
    private JLabel sizeLabel;
    private JSpinner sizeSpinner;

    ArrayCustomEditor(PropertyEditor editor, PropertyEnv env) {
        this.editor = editor;
        this.env = env;
        this.initComponents();
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addPropertyChangeListener((PropertyChangeListener)this);
        this.populateTable();
        this.tableSizeChanged();
        this.arrayTable.getModel().addTableModelListener(e -> {
            if (e.getType() != 0) {
                this.tableSizeChanged();
            }
        });
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.arrayTable = new ArrayTable();
        this.sizeLabel = new JLabel();
        this.sizeSpinner = new JSpinner();
        this.arrayTable.setSelectionMode(1);
        this.scrollPane.setViewportView(this.arrayTable);
        this.sizeLabel.setText(NbBundle.getMessage(ArrayCustomEditor.class, (String)"ArrayCustomEditor.sizeLabel.text"));
        this.sizeSpinner.setModel(new SpinnerNumberModel(0, 0, 512, 1));
        this.sizeSpinner.setName("");
        this.sizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ArrayCustomEditor.this.sizeSpinnerStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 400, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.sizeLabel).addGap(6, 6, 6).addComponent(this.sizeSpinner, -2, 60, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.scrollPane, -2, 275, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sizeLabel).addComponent(this.sizeSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void sizeSpinnerStateChanged(ChangeEvent evt) {
        if (this.ignore) {
            return;
        }
        this.ignore = true;
        DefaultTableModel model = (DefaultTableModel)this.arrayTable.getModel();
        model.setRowCount((Integer)this.sizeSpinner.getValue());
        this.ignore = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
            this.setFromTable();
        }
    }

    private void tableSizeChanged() {
        if (this.ignore) {
            return;
        }
        this.ignore = true;
        this.sizeSpinner.setValue(this.arrayTable.getRowCount());
        this.ignore = false;
    }

    private void setFromTable() {
        int count = this.arrayTable.getRowCount();
        ArrayList<Object> values = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            Object o = this.arrayTable.getValueAt(i, 0);
            if (o == null) {
                values.add(PString.EMPTY);
                continue;
            }
            String s = o.toString();
            if (s.isEmpty()) {
                values.add(PString.EMPTY);
                continue;
            }
            try {
                values.add(PNumber.parse((String)s));
                continue;
            }
            catch (ValueFormatException ex) {
                values.add(PString.of((String)s));
            }
        }
        this.editor.setValue(PArray.of(values));
    }

    private void populateTable() {
        DefaultTableModel model = (DefaultTableModel)this.arrayTable.getModel();
        model.setRowCount(0);
        PArray values = PArray.from((Value)((Value)this.editor.getValue())).orElse(PArray.EMPTY);
        for (Value v : values) {
            model.addRow(new Object[]{v.toString()});
        }
    }
}

