/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.editors;

import org.praxislive.core.Value;
import org.praxislive.core.ValueFormatException;
import org.praxislive.core.types.PBoolean;
import org.praxislive.ide.properties.EditorSupport;

public class BooleanEditor
extends EditorSupport {
    public void setValue(Object value) {
        if (!(value instanceof Value)) {
            throw new IllegalArgumentException();
        }
        super.setValue(PBoolean.from((Value)((Value)value)).orElseThrow(IllegalArgumentException::new));
    }

    public void setAsText(String text) throws IllegalArgumentException {
        try {
            this.setValue(PBoolean.parse((String)text));
        }
        catch (ValueFormatException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String[] getTags() {
        return new String[]{"true", "false"};
    }

    public String getPraxisInitializationString() {
        return PBoolean.from((Value)((Value)this.getValue())).map(PBoolean::toString).orElse(null);
    }

    public String getDisplayName() {
        return "Boolean Editor";
    }
}

