/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.spi;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.praxislive.ide.model.RootProxy;
import org.praxislive.ide.project.api.PraxisProject;

public interface RootEditor {
    public JComponent getEditorComponent();

    default public void componentShowing() {
    }

    default public void componentActivated() {
        this.requestFocus();
    }

    default public void componentDeactivated() {
    }

    default public void componentHidden() {
    }

    default public void sync() {
    }

    default public void dispose() {
    }

    default public List<Action> getActions() {
        return List.of();
    }

    default public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    default public UndoRedo getUndoRedo() {
        return UndoRedo.NONE;
    }

    default public boolean requestFocus() {
        return this.getEditorComponent().requestFocusInWindow();
    }

    default public Set<ToolAction> supportedToolActions() {
        return EnumSet.noneOf(ToolAction.class);
    }

    public static enum ToolAction {
        ADD,
        SELECT,
        CALL,
        CONNECT,
        DISCONNECT;

    }

    public static interface Context {
        public TopComponent container();

        public ExplorerManager explorerManager();

        public Optional<FileObject> file();

        public Optional<PraxisProject> project();

        public Optional<Action> sharedCodeAction();
    }

    public static interface Provider {
        public Optional<RootEditor> createEditor(RootProxy var1, Context var2);
    }
}

