/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2014 Neil C Smith.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 for more details.
 *
 * You should have received a copy of the GNU General Public License version 3
 * along with this work; if not, see http://www.gnu.org/licenses/
 *
 *
 * Please visit https://www.praxislive.org if you need additional information or
 * have any questions.
 */
package org.praxislive.ide.pxr;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import org.praxislive.ide.properties.PraxisProperty;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;

/**
 *
 */
@SuppressWarnings("deprecation")
class DelegatingArgumentCustomEditor extends javax.swing.JPanel {

    private DelegatingArgumentEditor delegateEditor;
    private PropertyEnv env;
    private PraxisProperty.Editor[] allEditors;
    private PraxisProperty.Editor currentEditor;

    /** Creates new form DelegatingArgumentCustomEditor */
    DelegatingArgumentCustomEditor(DelegatingArgumentEditor delegateEditor, PropertyEnv env) {
        this.delegateEditor = delegateEditor;
        this.env = env;
        initComponents();
        allEditors = delegateEditor.getAllEditors();
        currentEditor = delegateEditor.getCurrentEditor();
        installEditors();
        installListeners();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        chooserLabel = new javax.swing.JLabel();
        chooser = new javax.swing.JComboBox<>();
        editors = new javax.swing.JPanel();

        chooserLabel.setLabelFor(chooser);
        chooserLabel.setText(org.openide.util.NbBundle.getMessage(DelegatingArgumentCustomEditor.class, "DelegatingArgumentCustomEditor.chooserLabel.text")); // NOI18N

        editors.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        editors.setLayout(new java.awt.CardLayout());

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(246, Short.MAX_VALUE)
                .addComponent(chooserLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(chooser, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
            .addComponent(editors, javax.swing.GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(chooser, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(chooserLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(editors, javax.swing.GroupLayout.DEFAULT_SIZE, 255, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox<String> chooser;
    private javax.swing.JLabel chooserLabel;
    private javax.swing.JPanel editors;
    // End of variables declaration//GEN-END:variables

    private void installEditors() {
        Object value = delegateEditor.getValue();
        for (int i = 0; i < allEditors.length; i++) {
            PraxisProperty.Editor ed = allEditors[i];
            if (ed != currentEditor) {
                try {
                    ed.setValue(value);
                } catch (Exception ex) {
                    // what here?
                }
                if (ed instanceof ExPropertyEditor) {
                    ((ExPropertyEditor) ed).attachEnv(env);
                }
            }
            Component custEd = null;
            if (ed.supportsCustomEditor()) {
                custEd = ed.getCustomEditor();
            }
            if (custEd == null || custEd instanceof Window) {
                custEd = new JPanel();
                // @TODO NO editor component
            }
            editors.add(custEd, "" + i);
//            if (ed instanceof org.praxislive.ide.pxr.api.PraxisPropertyEditor) {
//                chooser.addItem(((org.praxislive.ide.pxr.api.PraxisPropertyEditor)ed).getDisplayName());
//            } else {
                chooser.addItem(ed.getClass().getSimpleName());
//            }
            if (ed == currentEditor) {
                chooser.setSelectedIndex(i);
            }
        }
        setupCurrentEditor();
    }

    private void setupCurrentEditor() {
        int selected = chooser.getSelectedIndex();
        PraxisProperty.Editor ed = allEditors[selected];
        CardLayout cards = (CardLayout) editors.getLayout();
        cards.show(editors, "" + selected);
        if (ed != currentEditor) {
            delegateEditor.setCurrentEditor(ed);
            currentEditor = ed;
        }
        
    }

    private void installListeners() {
        chooser.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                setupCurrentEditor();
            }
        });
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addPropertyChangeListener(new PropertyChangeListener() {

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (PropertyEnv.PROP_STATE.equals(evt.getPropertyName())
                        && evt.getNewValue() == PropertyEnv.STATE_VALID) {
                }
            }
        });
    }
}
