/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2025 Neil C Smith.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 for more details.
 *
 * You should have received a copy of the GNU General Public License version 3
 * along with this work; if not, see http://www.gnu.org/licenses/
 *
 *
 * Please visit https://www.praxislive.org if you need additional information or
 * have any questions.
 */
package org.praxislive.ide.pxr.options;

import org.praxislive.ide.pxr.EditorModes;

final class PXROptionsPanel extends javax.swing.JPanel {

    private final PXROptionsPanelController controller;

    PXROptionsPanel(PXROptionsPanelController controller) {
        this.controller = controller;
        initComponents();
        // TODO listen to changes in form fields and call controller.changed()
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        tabGroupButtonGroup = new javax.swing.ButtonGroup();
        tabGroupLabel = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        tabGroupDesc = new javax.swing.JLabel();
        tabGroupDefault = new javax.swing.JRadioButton();
        tabGroupAlways = new javax.swing.JRadioButton();
        tabGroupNever = new javax.swing.JRadioButton();

        org.openide.awt.Mnemonics.setLocalizedText(tabGroupLabel, org.openide.util.NbBundle.getMessage(PXROptionsPanel.class, "PXROptionsPanel.tabGroupLabel.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(tabGroupDesc, org.openide.util.NbBundle.getMessage(PXROptionsPanel.class, "PXROptionsPanel.tabGroupDesc.text")); // NOI18N

        tabGroupButtonGroup.add(tabGroupDefault);
        org.openide.awt.Mnemonics.setLocalizedText(tabGroupDefault, org.openide.util.NbBundle.getMessage(PXROptionsPanel.class, "PXROptionsPanel.tabGroupDefault.text")); // NOI18N
        tabGroupDefault.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tabGroupDefaultActionPerformed(evt);
            }
        });

        tabGroupButtonGroup.add(tabGroupAlways);
        org.openide.awt.Mnemonics.setLocalizedText(tabGroupAlways, org.openide.util.NbBundle.getMessage(PXROptionsPanel.class, "PXROptionsPanel.tabGroupAlways.text")); // NOI18N
        tabGroupAlways.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tabGroupAlwaysActionPerformed(evt);
            }
        });

        tabGroupButtonGroup.add(tabGroupNever);
        org.openide.awt.Mnemonics.setLocalizedText(tabGroupNever, org.openide.util.NbBundle.getMessage(PXROptionsPanel.class, "PXROptionsPanel.tabGroupNever.text")); // NOI18N
        tabGroupNever.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tabGroupNeverActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(tabGroupLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jSeparator1)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(tabGroupNever)
                            .addComponent(tabGroupAlways)
                            .addComponent(tabGroupDefault)
                            .addComponent(tabGroupDesc))
                        .addGap(0, 41, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(tabGroupLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(tabGroupDesc)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(tabGroupDefault)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(tabGroupAlways)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(tabGroupNever)
                .addContainerGap(216, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void tabGroupDefaultActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tabGroupDefaultActionPerformed
        controller.changed();
    }//GEN-LAST:event_tabGroupDefaultActionPerformed

    private void tabGroupAlwaysActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tabGroupAlwaysActionPerformed
        controller.changed();
    }//GEN-LAST:event_tabGroupAlwaysActionPerformed

    private void tabGroupNeverActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tabGroupNeverActionPerformed
        controller.changed();
    }//GEN-LAST:event_tabGroupNeverActionPerformed

    void load() {
        switch (EditorModes.getDefault().getActiveConfiguration()) {
            case Always ->
                tabGroupAlways.setSelected(true);
            case Never ->
                tabGroupNever.setSelected(true);
            default ->
                tabGroupDefault.setSelected(true);
        }

    }

    void store() {
        if (tabGroupAlways.isSelected()) {
            EditorModes.getDefault().setActiveConfiguration(EditorModes.Configuration.Always);
        } else if (tabGroupNever.isSelected()) {
            EditorModes.getDefault().setActiveConfiguration(EditorModes.Configuration.Never);
        } else {
            EditorModes.getDefault().setActiveConfiguration(EditorModes.Configuration.Default);
        }
    }

    boolean valid() {
        return true;
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JRadioButton tabGroupAlways;
    private javax.swing.ButtonGroup tabGroupButtonGroup;
    private javax.swing.JRadioButton tabGroupDefault;
    private javax.swing.JLabel tabGroupDesc;
    private javax.swing.JLabel tabGroupLabel;
    private javax.swing.JRadioButton tabGroupNever;
    // End of variables declaration//GEN-END:variables
}
