/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.praxislive.core.ComponentType;
import org.praxislive.ide.core.api.Task;
import org.praxislive.ide.pxr.PXRComponentProxy;
import org.praxislive.ide.pxr.PXRContainerProxy;
import org.praxislive.ide.pxr.PXRRootProxy;
import org.praxislive.ide.pxr.api.ActionSupport;
import org.praxislive.ide.pxr.spi.RootEditor;

public class ActionEditorContext {
    static final String CONTEXT = "context";
    static final String SELECTION = "selection";
    private final PropertyChangeSupport pcs;
    private final RootEditor editor;
    private final PXRRootProxy root;
    private final Node palette;
    private final BiConsumer<PXRContainerProxy, List<PXRComponentProxy>> selector;
    private PXRContainerProxy context;
    private List<PXRComponentProxy> selection;

    ActionEditorContext(RootEditor editor, PXRRootProxy root, Node palette, BiConsumer<PXRContainerProxy, List<PXRComponentProxy>> selector) {
        this.editor = Objects.requireNonNull(editor);
        this.root = Objects.requireNonNull(root);
        this.palette = Objects.requireNonNull(palette);
        this.selector = Objects.requireNonNull(selector);
        this.pcs = new PropertyChangeSupport(this);
        this.context = root;
        this.selection = List.of();
    }

    RootEditor editor() {
        return this.editor;
    }

    PXRRootProxy root() {
        return this.root;
    }

    PXRContainerProxy context() {
        return this.context;
    }

    List<PXRComponentProxy> selection() {
        return this.selection;
    }

    Node palette() {
        return this.palette;
    }

    void select(PXRContainerProxy container, List<PXRComponentProxy> selection) {
        this.selector.accept(container, selection);
    }

    void updateSelection(PXRContainerProxy context, List<PXRComponentProxy> selection) {
        boolean contextChanged;
        if (context != this.context) {
            if (context.getRoot() != this.root) {
                throw new IllegalArgumentException();
            }
            contextChanged = true;
        } else {
            contextChanged = false;
        }
        List<PXRComponentProxy> oldSelection = selection;
        this.selection = List.copyOf(selection);
        if (contextChanged) {
            PXRContainerProxy oldContext = this.context;
            this.context = context;
            this.pcs.firePropertyChange(CONTEXT, oldContext, context);
        }
        this.pcs.firePropertyChange(SELECTION, oldSelection, selection);
    }

    void acceptComponentType(ComponentType type) {
        PXRContainerProxy container = this.context();
        Task.WithResult<String> task = ActionSupport.createAddChildTask(this.editor(), container, type);
        Task.WithResult.compute(task).thenAccept(childID -> this.select(container, List.of(container.getChild((String)childID))));
    }

    void acceptImport(FileObject fo) {
        ActionSupport.createImportTask(this.editor(), this.context(), fo).execute();
    }
}

