/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.openide.awt.DynamicMenuContent;
import org.openide.explorer.view.MenuView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.praxislive.core.ComponentType;
import org.praxislive.ide.pxr.ActionEditorContext;
import org.praxislive.ide.pxr.Bundle;

public class AddChildAction
extends AbstractAction
implements ContextAwareAction,
Presenter.Popup,
Presenter.Menu {
    public static final String ID = "org.praxislive.ide.pxr.AddChildAction";
    private final Lookup.Result<ActionEditorContext> result;
    private final LookupListener listener;
    private final DynMenu menu = new DynMenu();
    private ActionEditorContext editorContext;
    private MenuView.Menu paletteView;

    public AddChildAction() {
        this(Utilities.actionsGlobalContext());
    }

    private AddChildAction(Lookup context) {
        super(Bundle.CTL_AddChildAction());
        this.result = context.lookupResult(ActionEditorContext.class);
        this.listener = this::resultChanged;
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.listener, this.result));
        this.setEnabled(false);
        this.resultChanged(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public Action createContextAwareInstance(Lookup lkp) {
        ActionEditorContext context = (ActionEditorContext)lkp.lookup(ActionEditorContext.class);
        if (context != null) {
            return new AddChildAction(lkp);
        }
        return this;
    }

    public JMenuItem getPopupPresenter() {
        return this.menu;
    }

    public JMenuItem getMenuPresenter() {
        return this.menu;
    }

    private void resultChanged(LookupEvent ev) {
        this.editorContext = null;
        this.paletteView = null;
        Collection contexts = this.result.allInstances();
        if (contexts.size() == 1) {
            this.editorContext = (ActionEditorContext)contexts.iterator().next();
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    private boolean acceptChoice(Node[] nodes) {
        if (nodes.length == 1) {
            ComponentType type = (ComponentType)nodes[0].getLookup().lookup(ComponentType.class);
            if (type != null) {
                EventQueue.invokeLater(() -> this.editorContext.acceptComponentType(type));
                return true;
            }
            FileObject fo = (FileObject)nodes[0].getLookup().lookup(FileObject.class);
            if (fo != null) {
                EventQueue.invokeLater(() -> this.editorContext.acceptImport(fo));
                return true;
            }
        }
        return false;
    }

    private class DynMenu
    extends JMenuItem
    implements DynamicMenuContent {
        private DynMenu() {
            super(AddChildAction.this);
        }

        public JComponent[] getMenuPresenters() {
            if (AddChildAction.this.editorContext != null) {
                if (AddChildAction.this.paletteView == null) {
                    AddChildAction.this.paletteView = new MenuView.Menu(AddChildAction.this.editorContext.palette(), AddChildAction.this::acceptChoice);
                    AddChildAction.this.paletteView.setIcon(null);
                    AddChildAction.this.paletteView.setText(Bundle.CTL_AddChildAction());
                }
                return new JComponent[]{AddChildAction.this.paletteView};
            }
            return new JComponent[]{this};
        }

        public JComponent[] synchMenuPresenters(JComponent[] jcs) {
            return this.getMenuPresenters();
        }
    }
}

