/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.BinaryOperator;
import org.praxislive.core.Value;
import org.praxislive.core.types.PMap;
import org.praxislive.project.GraphBuilder;
import org.praxislive.project.GraphElement;
import org.praxislive.project.GraphModel;

class AttrUtils {
    private AttrUtils() {
    }

    static GraphModel rewriteAttr(GraphModel model) {
        return model.withTransform(r -> AttrUtils.rewriteAttrImpl(r));
    }

    private static void rewriteAttrImpl(GraphBuilder.Base<?> cmp) {
        PMap.Builder mb = PMap.builder();
        for (GraphElement.Comment comment : cmp.comments()) {
            int delim;
            String txt = comment.text().strip();
            if (!txt.startsWith("%") || (delim = txt.indexOf(" ")) <= 1) continue;
            mb.put(txt.substring(1, delim), AttrUtils.unescape(txt.substring(delim + 1)));
        }
        PMap attr = mb.build();
        cmp.transformProperties(props -> {
            ArrayList result = new ArrayList(props.toList());
            int index = -1;
            for (int i = 0; i < result.size(); ++i) {
                if (!"meta".equals(((Map.Entry)result.get(i)).getKey())) continue;
                index = i;
                break;
            }
            if (index > -1) {
                PMap existing = (PMap)PMap.from((Value)((GraphElement.Property)((Map.Entry)result.get(index)).getValue()).value()).orElseThrow();
                result.set(index, Map.entry("meta", GraphElement.property((Value)PMap.merge((PMap)existing, (PMap)attr, (BinaryOperator)PMap.REPLACE))));
            } else {
                result.add(0, Map.entry("meta", GraphElement.property((Value)attr)));
            }
            return result;
        });
        cmp.transformComments(comments -> comments.filter(c -> !c.text().strip().startsWith("%")).toList());
        cmp.transformChildren(children -> children.map(e -> {
            GraphBuilder.Component child = GraphBuilder.component((GraphElement.Component)((GraphElement.Component)e.getValue()));
            AttrUtils.rewriteAttrImpl(child);
            return Map.entry((String)e.getKey(), child.build());
        }).toList());
    }

    /*
     * Unable to fully structure code
     */
    private static String unescape(String text) {
        if (!text.contains("\\")) {
            return text;
        }
        len = text.length();
        sb = new StringBuilder(len);
        block5: for (i = 0; i < len; ++i) {
            c = text.charAt(i);
            if (c != '\\') ** GOTO lbl-1000
            c = text.charAt(++i);
            switch (c) {
                case 'n': {
                    sb.append('\n');
                    continue block5;
                }
                case 't': {
                    sb.append('\t');
                    continue block5;
                }
                case 'r': {
                    continue block5;
                }
                default: lbl-1000:
                // 2 sources

                {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

