/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.praxislive.core.ControlInfo;
import org.praxislive.ide.properties.EditorSupport;
import org.praxislive.ide.properties.PraxisProperty;
import org.praxislive.ide.pxr.BoundArgumentProperty;
import org.praxislive.ide.pxr.DelegatingArgumentCustomEditor;
import org.praxislive.ide.pxr.SubCommandArgument;
import org.praxislive.ide.pxr.editors.EditorManager;

class DelegatingArgumentEditor
extends EditorSupport
implements ExPropertyEditor,
PraxisProperty.DelegateEditor {
    private static final Logger LOG = Logger.getLogger(DelegatingArgumentEditor.class.getName());
    private PraxisProperty.Editor defaultEditor;
    private PraxisProperty.Editor currentEditor;
    private PraxisProperty.Editor[] allEditors;
    private DelegateListener dl;
    private BoundArgumentProperty property;
    private ControlInfo info;
    private PropertyEnv env;

    DelegatingArgumentEditor(BoundArgumentProperty property, ControlInfo info) {
        this.property = property;
        this.info = info;
        this.currentEditor = this.defaultEditor = EditorManager.getDefaultEditor((PraxisProperty)property, info);
        property.setValue("editor", this.currentEditor);
        this.dl = new DelegateListener();
        this.currentEditor.addPropertyChangeListener((PropertyChangeListener)this.dl);
    }

    public String getPraxisInitializationString() {
        return this.currentEditor.getPraxisInitializationString();
    }

    public String getDisplayName() {
        return this.currentEditor.getClass().getSimpleName();
    }

    public void setValue(Object value) {
        if (value instanceof SubCommandArgument) {
            try {
                LOG.finest("Delegate setting from command line");
                this.setFromCommand(((SubCommandArgument)((Object)value)).getCommandLine());
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Editor threw exception in command line", ex);
                throw new IllegalArgumentException(ex);
            }
        } else {
            this.currentEditor.setValue(value);
        }
    }

    private void setFromCommand(String command) throws Exception {
        PraxisProperty.SubCommandEditor cEd;
        Exception lastEx = null;
        if (this.currentEditor instanceof PraxisProperty.SubCommandEditor && this.editorSupportsCommandLine(cEd = (PraxisProperty.SubCommandEditor)this.currentEditor, command)) {
            try {
                cEd.setFromCommand(command);
                return;
            }
            catch (Exception ex) {
                lastEx = ex;
            }
        }
        for (PraxisProperty.Editor ed : this.getAllEditors()) {
            if (ed == this.currentEditor || !(ed instanceof PraxisProperty.SubCommandEditor) || !this.editorSupportsCommandLine(cEd = (PraxisProperty.SubCommandEditor)ed, command)) continue;
            try {
                cEd.setFromCommand(command);
                this.setCurrentEditor(ed);
                return;
            }
            catch (Exception ex) {
                lastEx = ex;
            }
        }
        if (lastEx == null) {
            throw new IllegalArgumentException("Couldn't find editor matching command");
        }
        throw new IllegalArgumentException(lastEx);
    }

    private boolean editorSupportsCommandLine(PraxisProperty.SubCommandEditor editor, String line) {
        for (String cmd : editor.getSupportedCommands()) {
            if (!line.startsWith(cmd + " ")) continue;
            return true;
        }
        return false;
    }

    public Object getValue() {
        return this.currentEditor.getValue();
    }

    public boolean isPaintable() {
        return this.currentEditor.isPaintable();
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        this.currentEditor.paintValue(gfx, box);
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String getAsText() {
        return this.currentEditor.getAsText();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.currentEditor.setAsText(text);
    }

    public String[] getTags() {
        return this.currentEditor.getTags();
    }

    public Component getCustomEditor() {
        if (this.allEditors != null && this.allEditors.length > 1 || EditorManager.hasAdditionalEditors(this.property, this.info)) {
            return new DelegatingArgumentCustomEditor(this, this.env);
        }
        return this.currentEditor.getCustomEditor();
    }

    public boolean supportsCustomEditor() {
        if (this.allEditors == null) {
            return this.currentEditor.supportsCustomEditor() || EditorManager.hasAdditionalEditors(this.property, this.info);
        }
        return this.currentEditor.supportsCustomEditor() || this.allEditors.length > 1;
    }

    void setCurrentEditor(PraxisProperty.Editor editor) {
        if (this.currentEditor != editor) {
            this.currentEditor.removePropertyChangeListener((PropertyChangeListener)this.dl);
            this.currentEditor.reset();
            this.currentEditor = editor;
            this.property.setValue("editor", editor);
            this.currentEditor.addPropertyChangeListener((PropertyChangeListener)this.dl);
            LOG.fine("Setting current editor to " + editor.getClass().getSimpleName());
        }
    }

    void restoreDefaultEditor() {
        this.setCurrentEditor(this.defaultEditor);
    }

    public PraxisProperty.Editor getCurrentEditor() {
        return this.currentEditor;
    }

    PraxisProperty.Editor[] getAllEditors() {
        if (this.allEditors == null) {
            this.initializeAllEditors();
        }
        return this.allEditors;
    }

    private void initializeAllEditors() {
        if (EditorManager.hasAdditionalEditors(this.property, this.info)) {
            PraxisProperty.Editor[] additional = EditorManager.getAdditionalEditors(this.property, this.info);
            PraxisProperty.Editor[] all = new PraxisProperty.Editor[additional.length + 1];
            all[0] = this.defaultEditor;
            System.arraycopy(additional, 0, all, 1, additional.length);
            this.allEditors = all;
        } else {
            this.allEditors = new PraxisProperty.Editor[]{this.defaultEditor};
        }
    }

    public void attachEnv(PropertyEnv env) {
        if (this.currentEditor instanceof ExPropertyEditor) {
            ((ExPropertyEditor)this.currentEditor).attachEnv(env);
        }
        this.env = env;
    }

    public Object getAttribute(String key) {
        return this.currentEditor.getAttribute(key);
    }

    public String[] getAttributeKeys() {
        return this.currentEditor.getAttributeKeys();
    }

    public void reset() {
        this.currentEditor.reset();
    }

    private class DelegateListener
    implements PropertyChangeListener {
        private DelegateListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DelegatingArgumentEditor.this.firePropertyChange();
        }
    }
}

