/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openide.awt.DynamicMenuContent;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Value;
import org.praxislive.core.Watch;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PString;
import org.praxislive.ide.model.ComponentProxy;
import org.praxislive.ide.pxr.Bundle;
import org.praxislive.ide.pxr.api.Attributes;

public class ExposeControlsAction
extends AbstractAction
implements ContextAwareAction,
Presenter.Popup,
Presenter.Menu {
    public static final String ID = "org.praxislive.ide.pxr.ExposeControlsAction";
    private static final String EXPOSE_KEY = "expose";
    private final Lookup.Result<ComponentProxy> result;
    private final LookupListener listener;
    private final DynMenu menu = new DynMenu();

    public ExposeControlsAction() {
        this(Utilities.actionsGlobalContext());
    }

    private ExposeControlsAction(Lookup context) {
        super(Bundle.CTL_ExposeAction());
        this.result = context.lookupResult(ComponentProxy.class);
        this.listener = this::resultChanged;
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.listener, this.result));
        this.setEnabled(false);
        this.resultChanged(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public Action createContextAwareInstance(Lookup lkp) {
        return new ExposeControlsAction(lkp);
    }

    public JMenuItem getPopupPresenter() {
        return this.menu;
    }

    public JMenuItem getMenuPresenter() {
        return this.menu;
    }

    private void resultChanged(LookupEvent ev) {
        Collection components = this.result.allInstances();
        if (components.size() == 1) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    private class DynMenu
    extends JMenuItem
    implements DynamicMenuContent {
        private DynMenu() {
            super(ExposeControlsAction.this);
        }

        public JComponent[] getMenuPresenters() {
            List<String> exposed;
            Collection components = ExposeControlsAction.this.result.allInstances();
            if (components.size() != 1) {
                return new JComponent[0];
            }
            ComponentProxy component = (ComponentProxy)components.iterator().next();
            List<JCheckBoxMenuItem> items = this.buildExposeItems(component, exposed = this.currentlyExposed(component));
            if (items.isEmpty()) {
                return new JComponent[0];
            }
            JMenu menu = new JMenu(Bundle.CTL_ExposeAction());
            for (JCheckBoxMenuItem cbi : items) {
                cbi.addActionListener(e -> {
                    List<String> selection = this.extractSelection(menu);
                    if (!Objects.equals(exposed, selection)) {
                        this.updateExposed(component, selection);
                    }
                });
                menu.add(cbi);
            }
            menu.addSeparator();
            JMenuItem reset = new JMenuItem(Bundle.CTL_ResetExposeAction());
            reset.addActionListener(e -> Attributes.clear(component, ExposeControlsAction.EXPOSE_KEY));
            menu.add(reset);
            return new JComponent[]{menu};
        }

        public JComponent[] synchMenuPresenters(JComponent[] jcs) {
            return this.getMenuPresenters();
        }

        private List<JCheckBoxMenuItem> buildExposeItems(ComponentProxy component, List<String> exposed) {
            ComponentInfo info = component.getInfo();
            Node node = component.getNodeDelegate();
            ArrayList<JCheckBoxMenuItem> items = new ArrayList<JCheckBoxMenuItem>();
            for (String control : info.controls()) {
                ControlInfo controlInfo = info.controlInfo(control);
                if (controlInfo == null || !this.isExposable(control, controlInfo, node)) continue;
                JCheckBoxMenuItem cbi = new JCheckBoxMenuItem(this.findLabel(control, controlInfo), exposed.contains(control));
                cbi.putClientProperty("control", control);
                items.add(cbi);
            }
            return items;
        }

        private List<String> currentlyExposed(ComponentProxy component) {
            PArray exposed = Attributes.get(component, PArray.class, ExposeControlsAction.EXPOSE_KEY, null);
            if (exposed == null) {
                exposed = Optional.ofNullable(component.getInfo().properties().get(ExposeControlsAction.EXPOSE_KEY)).flatMap(PArray::from).orElse(PArray.EMPTY);
            }
            return exposed.asListOf(String.class);
        }

        private boolean isExposable(String control, ControlInfo controlInfo, Node node) {
            if (Watch.isWatch((ControlInfo)controlInfo)) {
                return true;
            }
            if (controlInfo.controlType() == ControlInfo.Type.Action) {
                for (Action a : node.getActions(false)) {
                    if (a == null || !control.equals(a.getValue("Name"))) continue;
                    return true;
                }
                return false;
            }
            for (Node.PropertySet propSet : node.getPropertySets()) {
                for (Node.Property prop : propSet.getProperties()) {
                    if (!control.equals(prop.getName())) continue;
                    return !prop.isHidden();
                }
            }
            return false;
        }

        private String findLabel(String id, ControlInfo controlInfo) {
            if (Watch.isWatch((ControlInfo)controlInfo)) {
                PMap watchInfo = Optional.ofNullable(controlInfo.properties().get("watch")).flatMap(PMap::from).orElse(PMap.EMPTY);
                return watchInfo.getString("related-port", id) + " (watch)";
            }
            return id;
        }

        private List<String> extractSelection(JMenu menu) {
            ArrayList<String> selected = new ArrayList<String>();
            for (Component c : menu.getMenuComponents()) {
                Object control;
                JCheckBoxMenuItem cbi;
                if (!(c instanceof JCheckBoxMenuItem) || !(cbi = (JCheckBoxMenuItem)c).isSelected() || !((control = cbi.getClientProperty("control")) instanceof String)) continue;
                String id = (String)control;
                selected.add(id);
            }
            return selected;
        }

        private void updateExposed(ComponentProxy component, List<String> selection) {
            if (selection.isEmpty()) {
                if (component.getInfo().properties().get(ExposeControlsAction.EXPOSE_KEY) != null) {
                    Attributes.set(component, ExposeControlsAction.EXPOSE_KEY, "<none>");
                } else {
                    Attributes.clear(component, ExposeControlsAction.EXPOSE_KEY);
                }
            } else {
                Attributes.set(component, ExposeControlsAction.EXPOSE_KEY, (Value)selection.stream().map(PString::of).collect(PArray.collector()));
            }
        }
    }
}

