/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;

class JSuggestField
extends JTextField {
    private final List<String> suggestions;
    private List<String> data = List.of();
    private JList list;
    private Matcher matcher;
    private Popup popup;
    private String lastWord = "";

    JSuggestField() {
        this.suggestions = new ArrayList<String>();
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorMoved(HierarchyEvent e) {
                JSuggestField.this.hideSuggest();
            }

            @Override
            public void ancestorResized(HierarchyEvent e) {
                JSuggestField.this.hideSuggest();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JSuggestField.this.hideSuggest();
            }
        });
        this.list = new JList();
        this.list.setFocusable(false);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                JSuggestField.this.setText((String)JSuggestField.this.list.getSelectedValue());
                JSuggestField.this.fireActionPerformed();
                JSuggestField.this.hideSuggest();
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int keycode = e.getKeyCode();
                if (keycode == 27) {
                    return;
                }
                if (keycode == 40 || keycode == 38) {
                    int diff;
                    int n = diff = keycode == 40 ? 1 : -1;
                    if (JSuggestField.this.isSuggestVisible()) {
                        JSuggestField.this.list.setSelectedIndex(JSuggestField.this.list.getSelectedIndex() + diff);
                        JSuggestField.this.list.ensureIndexIsVisible(JSuggestField.this.list.getSelectedIndex() + diff);
                        JSuggestField.this.setText((String)JSuggestField.this.list.getSelectedValue());
                    } else {
                        JSuggestField.this.showPopup();
                    }
                    return;
                }
                if (!(e.getKeyCode() != 10 && e.getKeyCode() != 9 || JSuggestField.this.list.getSelectedIndex() == -1 || JSuggestField.this.suggestions.isEmpty())) {
                    JSuggestField.this.setText((String)JSuggestField.this.list.getSelectedValue());
                    JSuggestField.this.hidePopup();
                    return;
                }
                JSuggestField.this.showSuggest();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    @Override
    protected void fireActionPerformed() {
        if (this.matcher != null) {
            this.matcher.stop = true;
            this.matcher = null;
        }
        super.fireActionPerformed();
    }

    void setSuggestData(List<String> data) {
        this.data = List.copyOf(data);
        this.list.setListData(this.data.toArray());
        this.suggestions.clear();
    }

    List<String> getSuggestData() {
        return this.data;
    }

    private void showSuggest() {
        if (!this.getText().toLowerCase().contains(this.lastWord.toLowerCase())) {
            this.suggestions.clear();
        }
        if (this.suggestions.isEmpty()) {
            this.suggestions.addAll(this.data);
        }
        if (this.matcher != null) {
            this.matcher.stop = true;
        }
        this.matcher = new Matcher();
        SwingUtilities.invokeLater(this.matcher);
        this.lastWord = this.getText();
    }

    private void hideSuggest() {
        this.hidePopup();
    }

    private void showPopup() {
        if (this.popup != null) {
            return;
        }
        JScrollPane scroll = new JScrollPane(this.list, 20, 30);
        Dimension dim = new Dimension(this.getSize().width, Math.min(12, this.data.size()) * (this.list.getCellRenderer().getListCellRendererComponent(this.list, "XXX", (int)0, (boolean)true, (boolean)true).getPreferredSize().height + 4));
        scroll.setPreferredSize(dim);
        Point loc = this.getLocationOnScreen();
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Rectangle screenBounds = gc.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        int screenHeight = screenBounds.height - screenInsets.bottom;
        loc.y = (double)(loc.y + this.getHeight()) + dim.getHeight() > (double)screenHeight ? (int)((double)loc.y - dim.getHeight()) : (loc.y += this.getHeight());
        this.popup = PopupFactory.getSharedInstance().getPopup(this, scroll, loc.x, loc.y);
        this.popup.show();
    }

    private void hidePopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    private boolean isSuggestVisible() {
        return this.popup != null;
    }

    private class Matcher
    implements Runnable {
        private boolean stop;

        private Matcher() {
        }

        @Override
        public void run() {
            if (this.stop || !JSuggestField.this.isVisible()) {
                return;
            }
            String word = JSuggestField.this.getText().toLowerCase(Locale.ROOT);
            JSuggestField.this.suggestions.clear();
            JSuggestField.this.data.forEach(datum -> {
                if (datum.toLowerCase(Locale.ROOT).startsWith(word)) {
                    JSuggestField.this.suggestions.add((String)datum);
                }
            });
            JSuggestField.this.data.forEach(datum -> {
                String lower = datum.toLowerCase(Locale.ROOT);
                if (!lower.startsWith(word) && lower.contains(word)) {
                    JSuggestField.this.suggestions.add((String)datum);
                }
            });
            if (!JSuggestField.this.suggestions.isEmpty()) {
                JSuggestField.this.list.setListData(JSuggestField.this.suggestions.toArray());
                JSuggestField.this.showPopup();
                JSuggestField.this.list.setSelectedIndex(0);
                JSuggestField.this.list.ensureIndexIsVisible(0);
            } else {
                JSuggestField.this.hidePopup();
            }
        }
    }
}

