/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BinaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.praxislive.base.Binding;
import org.praxislive.core.ArgumentInfo;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.ComponentType;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Value;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PString;
import org.praxislive.ide.core.api.Syncable;
import org.praxislive.ide.core.api.ValuePropertyAdaptor;
import org.praxislive.ide.model.ComponentProxy;
import org.praxislive.ide.properties.PraxisProperty;
import org.praxislive.ide.pxr.BoundArgumentProperty;
import org.praxislive.ide.pxr.BoundCodeProperty;
import org.praxislive.ide.pxr.PXRComponentEditor;
import org.praxislive.ide.pxr.PXRContainerProxy;
import org.praxislive.ide.pxr.PXRProxyNode;
import org.praxislive.ide.pxr.PXRRootProxy;
import org.praxislive.ide.pxr.api.Attributes;

public class PXRComponentProxy
implements ComponentProxy {
    private static final Logger LOG = Logger.getLogger(PXRComponentProxy.class.getName());
    private static final Registry registry = new Registry();
    private final Map<String, String> attributes;
    private final Set<Object> syncKeys;
    private final PropertyChangeSupport pcs;
    private final ComponentType type;
    private final boolean dynamic;
    private final InfoProperty infoProp;
    private final MetaProperty metaProp;
    PXRProxyNode node;
    private PXRContainerProxy parent;
    private ComponentInfo info;
    private Lookup lookup;
    private Map<String, BoundArgumentProperty> properties;
    private PropPropListener propertyListener;
    private List<Action> triggers;
    private List<Action> propActions;
    private Action codeAction;
    private EditorAction editorAction;
    boolean syncing;
    boolean nodeSyncing;
    boolean parentSyncing;
    private ValuePropertyAdaptor.ReadOnly dynInfoAdaptor;
    private ValuePropertyAdaptor.ReadOnly metaAdaptor;

    PXRComponentProxy(PXRContainerProxy parent, ComponentType type, ComponentInfo info) {
        this.parent = parent;
        this.type = type;
        this.info = info;
        this.attributes = new LinkedHashMap<String, String>();
        this.syncKeys = new HashSet<Object>();
        this.pcs = new PropertyChangeSupport(this);
        this.dynamic = info.properties().getBoolean("dynamic", false);
        this.infoProp = new InfoProperty();
        this.metaProp = new MetaProperty(PMap.EMPTY);
    }

    Lookup createLookup() {
        return Lookups.fixed((Object[])new Object[]{this.getRoot().getProject(), this.metaProp, new Sync()});
    }

    List<? extends PraxisProperty<?>> getProxyProperties() {
        return List.of(this.infoProp, this.metaProp);
    }

    boolean isHiddenFunction(String id) {
        return "meta-merge".equals(id);
    }

    private void initProperties() {
        assert (EventQueue.isDispatchThread());
        if (this.propertyListener == null) {
            this.propertyListener = new PropPropListener();
        }
        ComponentAddress cmpAd = this.getAddress();
        Map<Object, Object> oldProps = this.properties == null ? Collections.emptyMap() : this.properties;
        this.properties = new LinkedHashMap<String, BoundArgumentProperty>();
        File workingDir = this.getRoot().getWorkingDirectory();
        for (String string : this.info.controls()) {
            ControlInfo ctl = this.info.controlInfo(string);
            BoundArgumentProperty prop = (BoundArgumentProperty)((Object)oldProps.remove(string));
            if (prop != null && prop.getInfo().equals((Object)ctl)) {
                this.properties.put(string, prop);
                continue;
            }
            ControlAddress address = ControlAddress.of((ComponentAddress)cmpAd, (String)string);
            prop = this.createPropertyForControl(address, ctl);
            if (prop == null) continue;
            prop.addPropertyChangeListener(this.propertyListener);
            prop.setValue("address", address);
            prop.setValue("workingDir", workingDir);
            prop.setValue("componentInfo", this.info);
            this.properties.put(string, prop);
        }
        if (!oldProps.isEmpty()) {
            for (PraxisProperty praxisProperty : oldProps.values()) {
                ((BoundArgumentProperty)praxisProperty).dispose();
            }
            oldProps.clear();
        }
        if (this.syncing) {
            this.setPropertiesSyncing(true);
        }
    }

    private void initDynamic() {
        LOG.finest("Setting up dynamic component adaptor");
        this.dynInfoAdaptor = new ValuePropertyAdaptor.ReadOnly((Object)this, "info", true, Binding.SyncRate.None);
        this.dynInfoAdaptor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    PXRComponentProxy.this.refreshInfo((ComponentInfo)ComponentInfo.from((Value)((Value)evt.getNewValue())).orElseThrow());
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "", ex);
                }
            }
        });
        this.getRoot().getHelper().bind(ControlAddress.of((ComponentAddress)this.getAddress(), (String)"info"), (Binding.Adaptor)this.dynInfoAdaptor);
    }

    private void initMeta() {
        this.metaAdaptor = new ValuePropertyAdaptor.ReadOnly((Object)this, "meta", true, Binding.SyncRate.None);
        this.metaAdaptor.addPropertyChangeListener((PropertyChangeListener)this.metaProp);
        this.getRoot().getHelper().bind(ControlAddress.of((ComponentAddress)this.getAddress(), (String)"meta"), (Binding.Adaptor)this.metaAdaptor);
    }

    void refreshInfo(ComponentInfo info) {
        if (this.info.equals((Object)info)) {
            LOG.finest("Info is current");
            return;
        }
        LOG.finest("Info changed - revalidating");
        this.info = info;
        this.initProperties();
        this.triggers = null;
        this.propActions = null;
        if (this.node != null) {
            this.node.refreshProperties();
            this.node.refreshActions();
        }
        this.firePropertyChange("info", null, null);
    }

    boolean isDynamic() {
        return this.dynamic;
    }

    public ComponentAddress getAddress() {
        return this.parent == null ? null : this.parent.getAddress(this);
    }

    public PXRContainerProxy getParent() {
        return this.parent;
    }

    public ComponentType getType() {
        return this.type;
    }

    public ComponentInfo getInfo() {
        return this.info;
    }

    public Node getNodeDelegate() {
        if (this.node == null) {
            this.node = new PXRProxyNode(this);
        }
        return this.node;
    }

    void setAttr(String key, String value) {
        this.metaProp.setAttribute(key, value);
    }

    String getAttr(String key) {
        return this.metaProp.getAttribute(key);
    }

    String[] getAttrKeys() {
        return new String[0];
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(property, oldValue, newValue);
        if (this.node != null) {
            this.node.propertyChange(property, oldValue, newValue);
        }
    }

    public CompletionStage<List<Value>> send(String control, List<Value> args) {
        try {
            ControlAddress to = ControlAddress.of((ComponentAddress)this.getAddress(), (String)control);
            return this.getRoot().getHelper().send(to, args);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return CompletableFuture.failedStage(ex);
        }
    }

    List<Action> getTriggerActions() {
        if (this.triggers == null) {
            this.initTriggerActions();
        }
        return this.triggers;
    }

    private void initTriggerActions() {
        this.triggers = new ArrayList<Action>();
        for (String ctlID : this.info.controls()) {
            ControlInfo ctl = this.info.controlInfo(ctlID);
            if (ctl.controlType() != ControlInfo.Type.Action) continue;
            this.triggers.add(new TriggerAction(ctlID));
        }
        this.triggers = List.copyOf(this.triggers);
    }

    List<Action> getPropertyActions() {
        if (this.propActions == null) {
            this.initPropertyActions();
        }
        return this.propActions;
    }

    Action getCodeEditAction() {
        this.getPropertyActions();
        return this.codeAction;
    }

    private void initPropertyActions() {
        if (this.properties == null) {
            this.initProperties();
        }
        this.propActions = new ArrayList<Action>();
        BoundCodeProperty code = null;
        for (BoundArgumentProperty prop : this.properties.values()) {
            if (!(prop instanceof BoundCodeProperty)) continue;
            if ("code".equals(prop.getName())) {
                code = (BoundCodeProperty)prop;
                continue;
            }
            this.propActions.add(((BoundCodeProperty)prop).getEditAction());
            this.propActions.add(((BoundCodeProperty)prop).getResetAction());
        }
        if (code != null) {
            if (!this.propActions.isEmpty()) {
                this.propActions.add(null);
            }
            this.propActions.add(code.getEditAction());
            this.propActions.add(code.getResetAction());
            Action sharedBaseAction = code.getSharedBaseAction();
            if (sharedBaseAction != null) {
                this.propActions.add(sharedBaseAction);
            }
            this.codeAction = code.getQuickEditAction();
        }
        this.propActions = Collections.unmodifiableList(this.propActions);
    }

    Action getEditorAction() {
        if (this.editorAction == null) {
            this.editorAction = new EditorAction();
        }
        return this.editorAction;
    }

    public String[] getPropertyIDs() {
        if (this.properties == null) {
            this.initProperties();
        }
        return this.properties.keySet().toArray(new String[0]);
    }

    public BoundArgumentProperty getProperty(String id) {
        if (this.properties == null) {
            this.initProperties();
        }
        return this.properties.get(id);
    }

    protected BoundArgumentProperty createPropertyForControl(ControlAddress address, ControlInfo info) {
        String mime;
        if (this.isProxiedProperty(address.controlID())) {
            return null;
        }
        if (info.controlType() != ControlInfo.Type.Property && info.controlType() != ControlInfo.Type.ReadOnlyProperty) {
            return null;
        }
        List args = info.outputs();
        if (args.size() != 1) {
            return null;
        }
        if ("String".equals(((ArgumentInfo)args.get(0)).argumentType()) && (mime = ((ArgumentInfo)args.get(0)).properties().getString("mime-type", null)) != null) {
            return new BoundCodeProperty(this.getRoot().getProject(), address, info, mime);
        }
        return new BoundArgumentProperty(this.getRoot().getProject(), address, info);
    }

    protected boolean isProxiedProperty(String id) {
        return "info".equals(id) || "meta".equals(id);
    }

    PXRRootProxy getRoot() {
        return this.parent.getRoot();
    }

    void dispose() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Dispose called on {0}", this.getAddress());
        }
        if (this.metaAdaptor != null) {
            this.getRoot().getHelper().unbind(ControlAddress.of((ComponentAddress)this.getAddress(), (String)"meta"), (Binding.Adaptor)this.metaAdaptor);
        }
        if (this.dynInfoAdaptor != null) {
            this.getRoot().getHelper().unbind(ControlAddress.of((ComponentAddress)this.getAddress(), (String)"info"), (Binding.Adaptor)this.dynInfoAdaptor);
        }
        if (this.editorAction != null && this.editorAction.editor != null) {
            this.editorAction.editor.dispose();
        }
        if (this.properties == null) {
            return;
        }
        for (PraxisProperty praxisProperty : this.properties.values()) {
            if (!(praxisProperty instanceof BoundArgumentProperty)) continue;
            LOG.log(Level.FINE, "Calling dispose on {0} property", praxisProperty.getName());
            ((BoundArgumentProperty)praxisProperty).dispose();
        }
        this.parent = null;
        this.properties = null;
    }

    private void setNodeSyncing(boolean sync) {
        assert (EventQueue.isDispatchThread());
        this.nodeSyncing = sync;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Setting node syncing {0} on {1}", new Object[]{sync, this.getAddress()});
        }
        this.checkSyncing();
    }

    void setParentSyncing(boolean sync) {
        if (this.parentSyncing != sync) {
            this.parentSyncing = sync;
            this.checkSyncing();
        }
    }

    void checkSyncing() {
        boolean toSync;
        boolean bl = toSync = this.nodeSyncing || !this.syncKeys.isEmpty();
        if (toSync != this.syncing) {
            this.syncing = toSync;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Setting properties syncing {0} on {1}", new Object[]{toSync, this.getAddress()});
            }
            this.setPropertiesSyncing(toSync);
        }
        if (this.metaAdaptor == null) {
            this.initMeta();
        }
        if (this.syncing || this.parentSyncing) {
            this.metaAdaptor.setSyncRate(Binding.SyncRate.Low);
        } else {
            this.metaAdaptor.setSyncRate(Binding.SyncRate.None);
        }
        if (this.dynamic) {
            if (this.dynInfoAdaptor == null) {
                this.initDynamic();
            }
            if (this.syncing || this.parentSyncing) {
                this.dynInfoAdaptor.setSyncRate(Binding.SyncRate.Low);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Setting info syncing {0} on {1}", new Object[]{true, this.getAddress()});
                }
            } else {
                this.dynInfoAdaptor.setSyncRate(Binding.SyncRate.None);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Setting info syncing {0} on {1}", new Object[]{false, this.getAddress()});
                }
            }
        }
    }

    private void setPropertiesSyncing(boolean sync) {
        if (this.properties == null) {
            return;
        }
        for (PraxisProperty praxisProperty : this.properties.values()) {
            if (!(praxisProperty instanceof BoundArgumentProperty)) continue;
            ((BoundArgumentProperty)praxisProperty).setSyncing(sync);
        }
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = this.createLookup();
        }
        return this.lookup;
    }

    private class InfoProperty
    extends PraxisProperty<ComponentInfo> {
        private InfoProperty() {
            super(ComponentInfo.class);
            this.setName("info");
        }

        public ComponentInfo getValue() {
            return PXRComponentProxy.this.info;
        }

        public boolean canRead() {
            return true;
        }
    }

    private class MetaProperty
    extends PraxisProperty<PMap>
    implements Attributes,
    PropertyChangeListener {
        private PMap meta;

        private MetaProperty(PMap value) {
            super(PMap.class);
            this.setName("meta");
            this.meta = Objects.requireNonNull(value);
        }

        public boolean canRead() {
            return true;
        }

        public PMap getValue() {
            return this.meta;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PMap newMeta = PMap.from((Value)((Value)evt.getNewValue())).orElse(PMap.EMPTY);
            PMap oldMeta = this.meta;
            this.meta = newMeta;
            if (!newMeta.equivalent((Value)oldMeta)) {
                PXRComponentProxy.this.pcs.firePropertyChange("meta", oldMeta, newMeta);
            }
        }

        @Override
        public void setAttribute(String key, String value) {
            this.setAttributeValue(key, (Value)(value == null ? null : PString.of((String)value)));
        }

        @Override
        public String getAttribute(String key) {
            return this.meta.getString(key, null);
        }

        @Override
        public void setAttributeValue(String key, Value value) {
            PMap oldMeta = this.meta;
            PMap metaMerge = PMap.of((String)key, (Object)(value == null ? PString.EMPTY : value));
            this.meta = PMap.merge((PMap)oldMeta, (PMap)metaMerge, (BinaryOperator)PMap.REPLACE);
            PXRComponentProxy.this.send("meta-merge", List.of(metaMerge));
            PXRComponentProxy.this.pcs.firePropertyChange("meta", oldMeta, this.meta);
        }

        @Override
        public <T extends Value> T getAttributeValue(Class<T> type, String key) {
            Value value = this.meta.get(key);
            if (value == null) {
                return null;
            }
            if (type.isInstance(value)) {
                return (T)((Value)type.cast(value));
            }
            return (T)((Value)((Optional)Value.Type.of(type).converter().apply(value)).orElse(null));
        }
    }

    private class Sync
    implements Syncable {
        private Sync() {
        }

        public void addKey(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            PXRComponentProxy.this.syncKeys.add(key);
            PXRComponentProxy.this.checkSyncing();
        }

        public void removeKey(Object key) {
            if (PXRComponentProxy.this.syncKeys.remove(key)) {
                PXRComponentProxy.this.checkSyncing();
            }
        }
    }

    private class PropPropListener
    implements PropertyChangeListener {
        private PropPropListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PXRComponentProxy.this.firePropertyChange(evt.getPropertyName(), null, null);
        }
    }

    private class TriggerAction
    extends AbstractAction {
        private final String control;

        TriggerAction(String control) {
            super(control);
            this.control = control;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            PXRComponentProxy.this.send(this.control, List.of());
        }
    }

    private class EditorAction
    extends AbstractAction {
        private PXRComponentEditor editor;

        EditorAction() {
            super("Edit...");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.editor == null) {
                this.editor = new PXRComponentEditor(PXRComponentProxy.this);
            }
            this.editor.show();
        }
    }

    private static class Registry
    implements PropertyChangeListener {
        private final List<PXRComponentProxy> syncing = new ArrayList<PXRComponentProxy>();

        public Registry() {
            TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                assert (EventQueue.isDispatchThread());
                if ("activatedNodes".equals(evt.getPropertyName())) {
                    ArrayList<PXRComponentProxy> tmp = new ArrayList<PXRComponentProxy>();
                    Object[] nodes = TopComponent.getRegistry().getActivatedNodes();
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.log(Level.FINEST, "Activated nodes = {0}", Arrays.toString(nodes));
                    }
                    for (Object node : nodes) {
                        PXRComponentProxy cmp = (PXRComponentProxy)node.getLookup().lookup(PXRComponentProxy.class);
                        if (cmp == null) continue;
                        tmp.add(cmp);
                    }
                    this.syncing.removeAll(tmp);
                    for (PXRComponentProxy cmp : this.syncing) {
                        cmp.setNodeSyncing(false);
                    }
                    this.syncing.clear();
                    this.syncing.addAll(tmp);
                    for (PXRComponentProxy cmp : this.syncing) {
                        cmp.setNodeSyncing(true);
                    }
                    tmp.clear();
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }
}

