/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.openide.nodes.Node;
import org.praxislive.base.Binding;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Connection;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Value;
import org.praxislive.core.protocols.ContainerProtocol;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PString;
import org.praxislive.ide.core.api.ValuePropertyAdaptor;
import org.praxislive.ide.model.ContainerProxy;
import org.praxislive.ide.properties.PraxisProperty;
import org.praxislive.ide.pxr.PXRComponentProxy;
import org.praxislive.ide.pxr.PXRHelper;

public class PXRContainerProxy
extends PXRComponentProxy
implements ContainerProxy {
    private static final Logger LOG = Logger.getLogger(PXRContainerProxy.class.getName());
    private final Map<String, PXRComponentProxy> children = new LinkedHashMap<String, PXRComponentProxy>();
    private final Map<String, CompletionStage<PXRComponentProxy>> pendingChildren;
    private final Set<Connection> connections = new LinkedHashSet<Connection>();
    private final ChildrenProperty childProp;
    private final ConnectionsProperty conProp;
    private final SupportedTypesProperty supportedTypesProp;
    private ValuePropertyAdaptor.ReadOnly connectionsAdaptor;
    private ValuePropertyAdaptor.ReadOnly typesAdaptor;
    private ValuePropertyAdaptor.ReadOnly childrenAdaptor;

    PXRContainerProxy(PXRContainerProxy parent, ComponentType type, ComponentInfo info) {
        super(parent, type, info);
        this.pendingChildren = new LinkedHashMap<String, CompletionStage<PXRComponentProxy>>();
        this.childProp = new ChildrenProperty();
        this.conProp = new ConnectionsProperty();
        this.supportedTypesProp = new SupportedTypesProperty();
    }

    @Override
    List<? extends PraxisProperty<?>> getProxyProperties() {
        ArrayList<Object> proxies = new ArrayList<Object>();
        proxies.addAll(super.getProxyProperties());
        proxies.add((Object)this.childProp);
        proxies.add((Object)this.conProp);
        proxies.add(this.supportedTypesProp);
        return proxies;
    }

    @Override
    boolean isHiddenFunction(String id) {
        return switch (id) {
            case "add-child", "remove-child", "connect", "disconnect" -> true;
            default -> super.isHiddenFunction(id);
        };
    }

    public PXRComponentProxy getChild(String id) {
        return this.children.get(id);
    }

    public Stream<String> children() {
        return this.children.keySet().stream();
    }

    public List<ComponentType> supportedTypes() {
        return this.supportedTypesProp.types();
    }

    public CompletionStage<? extends PXRComponentProxy> addChild(String id, ComponentType type) {
        return this.addChild(id, type, PMap.EMPTY);
    }

    CompletionStage<? extends PXRComponentProxy> addChild(String id, ComponentType type, PMap attrs) {
        ComponentAddress childAddress = ComponentAddress.of((ComponentAddress)this.getAddress(), (String)id);
        PXRHelper helper = this.getRoot().getHelper();
        CompletionStage<PXRComponentProxy> stage = helper.createComponent(childAddress, type).thenCompose(ad -> {
            assert (EventQueue.isDispatchThread());
            return helper.componentData((ComponentAddress)ad);
        }).thenApply(data -> {
            assert (EventQueue.isDispatchThread());
            return this.addChildProxy(id, (PMap)data, attrs);
        }).whenComplete((c, ex) -> {
            assert (EventQueue.isDispatchThread());
            this.pendingChildren.remove(id);
        });
        this.pendingChildren.put(id, stage);
        return stage;
    }

    private void addChildProxy(String id) {
        ComponentAddress childAddress = ComponentAddress.of((ComponentAddress)this.getAddress(), (String)id);
        PXRHelper helper = this.getRoot().getHelper();
        CompletionStage<PXRComponentProxy> stage = helper.componentData(childAddress).thenApply(data -> {
            assert (EventQueue.isDispatchThread());
            return this.addChildProxy(id, (PMap)data, PMap.EMPTY);
        }).whenComplete((c, ex) -> {
            assert (EventQueue.isDispatchThread());
            this.pendingChildren.remove(id);
        });
        this.pendingChildren.put(id, stage);
    }

    private PXRComponentProxy addChildProxy(String id, PMap data, PMap attrs) {
        ComponentInfo info = (ComponentInfo)ComponentInfo.from((Value)data.get("%info")).orElseThrow();
        ComponentType type = (ComponentType)ComponentType.from((Value)data.get("%type")).orElseThrow();
        PXRComponentProxy child = this.isContainer(info) ? new PXRContainerProxy(this, type, info) : new PXRComponentProxy(this, type, info);
        this.children.put(id, child);
        attrs.keys().forEach(k -> child.setAttr((String)k, attrs.getString(k, null)));
        if (this.syncing) {
            child.setParentSyncing(true);
        }
        if (this.node != null) {
            this.node.refreshChildren();
        }
        this.firePropertyChange("children", null, null);
        return child;
    }

    private boolean isContainer(ComponentInfo info) {
        return info.hasProtocol(ContainerProtocol.class);
    }

    public CompletionStage<?> removeChild(String id) {
        ComponentAddress childAddress = ComponentAddress.of((ComponentAddress)this.getAddress(), (String)id);
        return this.getRoot().getHelper().removeComponent(childAddress).thenRun(() -> this.removeChildProxies(List.of(id)));
    }

    private void removeChildProxies(List<String> ids) {
        boolean conChanged = false;
        for (String id : ids) {
            PXRComponentProxy child = this.children.get(id);
            if (child != null) {
                child.dispose();
            }
            this.children.remove(id);
            Iterator<Connection> itr = this.connections.iterator();
            while (itr.hasNext()) {
                Connection con = itr.next();
                if (!con.sourceComponent().equals(id) && !con.targetComponent().equals(id)) continue;
                itr.remove();
                conChanged = true;
            }
        }
        if (conChanged) {
            this.firePropertyChange("connections", null, null);
        }
        if (this.node != null) {
            this.node.refreshChildren();
        }
        this.firePropertyChange("children", null, null);
    }

    public CompletionStage<Connection> connect(Connection connection) {
        return this.getRoot().getHelper().connect(this.getAddress(), connection).thenApply(c -> {
            this.connections.add((Connection)c);
            this.firePropertyChange("connections", null, null);
            return c;
        });
    }

    public CompletionStage<?> disconnect(Connection connection) {
        return this.getRoot().getHelper().disconnect(this.getAddress(), connection).thenApply(c -> {
            this.connections.remove(c);
            this.firePropertyChange("connections", null, null);
            return c;
        });
    }

    @Override
    public Node getNodeDelegate() {
        Node n = super.getNodeDelegate();
        n.getChildren().getNodes();
        return n;
    }

    ComponentAddress getAddress(PXRComponentProxy child) {
        String childID = this.getChildID(child);
        if (childID == null) {
            return null;
        }
        return ComponentAddress.of((ComponentAddress)this.getAddress(), (String)childID);
    }

    String getChildID(PXRComponentProxy child) {
        Set<Map.Entry<String, PXRComponentProxy>> entries = this.children.entrySet();
        for (Map.Entry<String, PXRComponentProxy> entry : entries) {
            if (entry.getValue() != child) continue;
            return entry.getKey();
        }
        return null;
    }

    public Stream<Connection> connections() {
        return this.connections.stream();
    }

    @Override
    protected boolean isProxiedProperty(String id) {
        return super.isProxiedProperty(id) || "children".equals(id) || "connections".equals(id) || "supported-types".equals(id);
    }

    @Override
    void checkSyncing() {
        super.checkSyncing();
        if (this.connectionsAdaptor == null) {
            if (this.syncing) {
                this.initAdaptors();
            } else {
                return;
            }
        }
        if (this.syncing) {
            this.childrenAdaptor.setSyncRate(Binding.SyncRate.Medium);
            this.connectionsAdaptor.setSyncRate(Binding.SyncRate.Medium);
            this.typesAdaptor.setSyncRate(Binding.SyncRate.Low);
            this.children.forEach((id, child) -> child.setParentSyncing(true));
        } else {
            this.childrenAdaptor.setSyncRate(Binding.SyncRate.None);
            this.connectionsAdaptor.setSyncRate(Binding.SyncRate.None);
            this.typesAdaptor.setSyncRate(Binding.SyncRate.None);
            this.children.forEach((id, child) -> child.setParentSyncing(false));
        }
    }

    private void initAdaptors() {
        this.childrenAdaptor = new ValuePropertyAdaptor.ReadOnly(null, "children", true, Binding.SyncRate.None);
        this.childrenAdaptor.addPropertyChangeListener((PropertyChangeListener)new ChildrenListener());
        this.connectionsAdaptor = new ValuePropertyAdaptor.ReadOnly(null, "connections", true, Binding.SyncRate.None);
        this.connectionsAdaptor.addPropertyChangeListener((PropertyChangeListener)new ConnectionsListener());
        this.typesAdaptor = new ValuePropertyAdaptor.ReadOnly(null, "supported-types", true, Binding.SyncRate.None);
        this.typesAdaptor.addPropertyChangeListener((PropertyChangeListener)this.supportedTypesProp);
        this.getRoot().getHelper().bind(ControlAddress.of((ComponentAddress)this.getAddress(), (String)"children"), (Binding.Adaptor)this.childrenAdaptor);
        this.getRoot().getHelper().bind(ControlAddress.of((ComponentAddress)this.getAddress(), (String)"connections"), (Binding.Adaptor)this.connectionsAdaptor);
        this.getRoot().getHelper().bind(ControlAddress.of((ComponentAddress)this.getAddress(), (String)"supported-types"), (Binding.Adaptor)this.typesAdaptor);
    }

    @Override
    void dispose() {
        for (PXRComponentProxy child : this.children.values()) {
            child.dispose();
        }
        this.children.clear();
        if (this.childrenAdaptor != null) {
            this.getRoot().getHelper().unbind(ControlAddress.of((ComponentAddress)this.getAddress(), (String)"children"), (Binding.Adaptor)this.childrenAdaptor);
            this.childrenAdaptor = null;
        }
        if (this.connectionsAdaptor != null) {
            this.getRoot().getHelper().unbind(ControlAddress.of((ComponentAddress)this.getAddress(), (String)"connections"), (Binding.Adaptor)this.connectionsAdaptor);
            this.connectionsAdaptor = null;
        }
        if (this.typesAdaptor != null) {
            this.getRoot().getHelper().unbind(ControlAddress.of((ComponentAddress)this.getAddress(), (String)"supported-types"), (Binding.Adaptor)this.typesAdaptor);
            this.typesAdaptor = null;
        }
        super.dispose();
    }

    private class ChildrenProperty
    extends PraxisProperty<PArray> {
        private ChildrenProperty() {
            super(PArray.class);
            this.setName("children");
        }

        public PArray getValue() {
            return (PArray)PXRContainerProxy.this.children().map(PString::of).collect(PArray.collector());
        }

        public boolean canRead() {
            return true;
        }
    }

    private class ConnectionsProperty
    extends PraxisProperty<PArray> {
        private ConnectionsProperty() {
            super(PArray.class);
            this.setName("connections");
        }

        public PArray getValue() {
            return PArray.of(PXRContainerProxy.this.connections);
        }

        public boolean canRead() {
            return true;
        }
    }

    private class SupportedTypesProperty
    extends PraxisProperty<PArray>
    implements PropertyChangeListener {
        private List<ComponentType> types;

        public SupportedTypesProperty() {
            super(PArray.class);
            this.setName("supported-types");
            this.types = List.of();
        }

        public boolean canRead() {
            return true;
        }

        public PArray getValue() {
            return PArray.of(this.types);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            List newTypes = PArray.from((Value)((Value)evt.getNewValue())).map(a -> a.stream().flatMap(v -> ComponentType.from((Value)v).stream()).toList()).orElse(List.of());
            if (!this.types.equals(newTypes)) {
                this.types = List.copyOf(newTypes);
                PXRContainerProxy.this.firePropertyChange("supported-types", null, null);
            }
        }

        private List<ComponentType> types() {
            return this.types;
        }
    }

    private class ChildrenListener
    implements PropertyChangeListener {
        private ChildrenListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                Set<String> childIDs = this.eventToChildIDs(evt);
                LinkedHashSet<String> scratch = new LinkedHashSet<String>(childIDs);
                scratch.removeAll(PXRContainerProxy.this.children.keySet());
                scratch.removeAll(PXRContainerProxy.this.pendingChildren.keySet());
                if (!scratch.isEmpty()) {
                    scratch.forEach(id -> PXRContainerProxy.this.addChildProxy((String)id));
                }
                scratch.clear();
                scratch.addAll(PXRContainerProxy.this.children.keySet());
                scratch.removeAll(childIDs);
                if (!scratch.isEmpty()) {
                    PXRContainerProxy.this.removeChildProxies(List.copyOf(scratch));
                }
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Invalid Children list", ex);
            }
        }

        private Set<String> eventToChildIDs(PropertyChangeEvent evt) throws Exception {
            return new LinkedHashSet<String>(((PArray)PArray.from((Value)((Value)evt.getNewValue())).orElseThrow()).asListOf(String.class));
        }
    }

    private class ConnectionsListener
    implements PropertyChangeListener {
        private ConnectionsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                Set<Connection> updated = this.eventToConnections(evt);
                if (PXRContainerProxy.this.connections.equals(updated)) {
                    LOG.fine("Connections change reported but we're up to date.");
                } else {
                    LOG.fine("Connections change reported - updating.");
                    PXRContainerProxy.this.connections.clear();
                    PXRContainerProxy.this.connections.addAll(updated);
                    PXRContainerProxy.this.firePropertyChange("connections", null, null);
                }
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Invalid Connection list", ex);
            }
        }

        private Set<Connection> eventToConnections(PropertyChangeEvent evt) throws Exception {
            return new LinkedHashSet<Connection>(((PArray)PArray.from((Value)((Value)evt.getNewValue())).orElseThrow()).asListOf(Connection.class));
        }
    }
}

