/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Set;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OpenSupport;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.CloneableTopComponent;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentType;
import org.praxislive.ide.components.api.Icons;
import org.praxislive.ide.core.api.Task;
import org.praxislive.ide.project.api.ExecutionLevel;
import org.praxislive.ide.project.api.ProjectProperties;
import org.praxislive.ide.pxr.PXRRootProxy;
import org.praxislive.ide.pxr.PXRRootRegistry;
import org.praxislive.ide.pxr.PXRWizardIterator;
import org.praxislive.ide.pxr.RootEditorTopComponent;
import org.praxislive.ide.pxr.SaveTask;
import org.praxislive.ide.pxr.TemplateDataObject;
import org.praxislive.project.GraphModel;

public class PXRDataObject
extends MultiDataObject {
    public static final String KEY_ATTR_ROOT_TYPE = "rootType";
    private static final RequestProcessor RP = new RequestProcessor();
    private final EditorSupport editorSupport = new EditorSupport();
    private final SaveSupport saveSupport = new SaveSupport();
    private String rootID;
    private Image icon;
    private DataNodeImpl node;

    public PXRDataObject(FileObject file, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(file, loader);
        CookieSet cookies = this.getCookieSet();
        cookies.add((Node.Cookie)this.editorSupport);
        cookies.add((Node.Cookie)this.saveSupport);
        cookies.add((Node.Cookie)new PXRWizardIterator());
        String fileID = file.getName();
        this.rootID = ComponentAddress.isValidID((String)fileID) ? fileID : "root";
        this.icon = Icons.defaultIcon();
        RP.execute(() -> {
            try {
                String script = file.asText();
                GraphModel model = GraphModel.parse((URI)file.getParent().toURI(), (String)script);
                EventQueue.invokeLater(() -> {
                    this.icon = Icons.getIcon((ComponentType)model.root().type());
                    this.rootID = model.root().id();
                    if (this.node != null) {
                        this.node.updateIcon();
                    }
                });
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
    }

    protected Node createNodeDelegate() {
        this.node = new DataNodeImpl(this, this.getLookup());
        return this.node;
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    void preSave() {
        this.editorSupport.syncEditors();
    }

    public boolean isCopyAllowed() {
        return false;
    }

    public boolean isMoveAllowed() {
        return false;
    }

    public boolean isRenameAllowed() {
        return false;
    }

    protected void handleDelete() throws IOException {
        Project owner = FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile());
        if (owner != null) {
            PXRRootProxy proxy = PXRRootRegistry.findRootForFile(this.getPrimaryFile());
            String id = proxy == null ? this.rootID : proxy.getID();
            EventQueue.invokeLater(() -> {
                ProjectProperties props = (ProjectProperties)owner.getLookup().lookup(ProjectProperties.class);
                if (props != null) {
                    try {
                        props.removeLine(ExecutionLevel.RUN, "/" + id + ".start");
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if (proxy != null) {
                    proxy.getHelper().removeComponent(ComponentAddress.of((String)("/" + id)));
                    proxy.dispose();
                }
            });
        }
        super.handleDelete();
    }

    static String findRootID(DataObject dob) {
        DataObject dataObject = dob;
        Objects.requireNonNull(dataObject);
        DataObject dataObject2 = dataObject;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PXRDataObject.class, TemplateDataObject.class}, (Object)dataObject2, n)) {
            case 0: {
                PXRDataObject pxrDob = (PXRDataObject)dataObject2;
                return pxrDob.rootID;
            }
            case 1: {
                TemplateDataObject templateDob = (TemplateDataObject)dataObject2;
                return templateDob.rootID;
            }
        }
        return "root";
    }

    private class EditorSupport
    extends OpenSupport
    implements OpenCookie,
    CloseCookie {
        EditorSupport() {
            super(PXRDataObject.this.getPrimaryEntry());
        }

        protected CloneableTopComponent createCloneableTopComponent() {
            return new RootEditorTopComponent(PXRDataObject.this);
        }

        private void syncEditors() {
            if (this.allEditors.isEmpty()) {
                return;
            }
            Enumeration editors = this.allEditors.getComponents();
            while (editors.hasMoreElements()) {
                RootEditorTopComponent rootEditor = (RootEditorTopComponent)((Object)editors.nextElement());
                rootEditor.syncEditor();
            }
        }
    }

    private class SaveSupport
    implements SaveCookie,
    PropertyChangeListener {
        private SaveTask task;

        private SaveSupport() {
        }

        public void save() throws IOException {
            if (this.task != null) {
                return;
            }
            this.task = SaveTask.createSaveTask(Set.of(PXRDataObject.this));
            this.task.addPropertyChangeListener(this);
            this.task.execute();
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if (this.task.getState() != Task.State.RUNNING) {
                this.task.removePropertyChangeListener(this);
                this.task = null;
            }
        }

        public String toString() {
            return PXRDataObject.this.getName();
        }
    }

    private static class DataNodeImpl
    extends DataNode {
        PXRDataObject dob;

        private DataNodeImpl(PXRDataObject dob, Lookup lookup) {
            super((DataObject)dob, Children.LEAF, lookup);
            this.dob = dob;
        }

        private void updateIcon() {
            this.fireIconChange();
        }

        public Image getIcon(int type) {
            return this.dob.icon;
        }
    }
}

