/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.EventQueue;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import javax.swing.SwingUtilities;
import org.netbeans.api.actions.Openable;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.Value;
import org.praxislive.core.types.PError;
import org.praxislive.ide.core.api.CallExecutionException;
import org.praxislive.ide.core.api.Callback;
import org.praxislive.ide.project.api.ExecutionElement;
import org.praxislive.ide.project.api.ExecutionLevel;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.project.spi.FileHandler;
import org.praxislive.ide.pxr.AttrUtils;
import org.praxislive.ide.pxr.PXRDataObject;
import org.praxislive.ide.pxr.PXRHelper;
import org.praxislive.ide.pxr.PXRRootProxy;
import org.praxislive.ide.pxr.PXRRootRegistry;
import org.praxislive.project.GraphBuilder;
import org.praxislive.project.GraphElement;
import org.praxislive.project.GraphModel;

public class PXRFileHandler
implements FileHandler {
    private static final RequestProcessor RP = new RequestProcessor();
    private final PraxisProject project;
    private final PXRDataObject source;
    private final List<String> warnings;
    private Callback callback;

    public PXRFileHandler(PraxisProject project, PXRDataObject source) {
        if (project == null || source == null) {
            throw new NullPointerException();
        }
        this.project = project;
        this.source = source;
        this.warnings = new ArrayList<String>();
    }

    public void process(Callback callback) throws Exception {
        if (callback == null) {
            throw new NullPointerException();
        }
        this.callback = callback;
        this.warnings.clear();
        PXRRootProxy root = PXRRootRegistry.findRootForFile(this.source.getPrimaryFile());
        if (root != null) {
            callback.onReturn(List.of());
            return;
        }
        RP.execute(() -> {
            try {
                String script = this.source.getPrimaryFile().asText();
                URI context = this.project.getProjectDirectory().toURI();
                GraphModel model = GraphModel.parse((URI)context, (String)script);
                SwingUtilities.invokeLater(() -> this.build(context, model));
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                SwingUtilities.invokeLater(() -> callback.onError(List.of(PError.of((Exception)ex))));
            }
        });
    }

    public List<String> warnings() {
        return this.warnings;
    }

    private void build(URI context, GraphModel fileModel) {
        PXRHelper helper = (PXRHelper)((Object)this.project.getLookup().lookup(PXRHelper.class));
        if (helper == null) {
            throw new IllegalStateException("No PXRHelper found");
        }
        GraphModel model = AttrUtils.rewriteAttr(fileModel);
        GraphModel root = model.withTransform(r -> {
            r.clearChildren();
            r.clearConnections();
        });
        String rootID = model.root().id();
        ComponentAddress rootAddress = ComponentAddress.of((String)("/" + rootID));
        GraphBuilder.Root subBuilder = GraphBuilder.syntheticRoot();
        model.root().children().forEach((arg_0, arg_1) -> ((GraphBuilder.Root)subBuilder).child(arg_0, arg_1));
        model.root().connections().forEach(arg_0 -> ((GraphBuilder.Root)subBuilder).connection(arg_0));
        GraphModel sub = GraphModel.of((GraphElement.Root)subBuilder.build(), (URI)context);
        Openable open = (Openable)this.source.getLookup().lookup(Openable.class);
        if (open != null) {
            open.open();
        }
        helper.safeEval(context, root.writeToString()).exceptionally(this::handleException).thenCompose(r -> helper.componentInfo(rootAddress)).thenAccept(info -> {
            assert (EventQueue.isDispatchThread());
            ((PXRRootRegistry)this.project.getLookup().lookup(PXRRootRegistry.class)).register(new PXRRootProxy(this.project, helper, this.source, rootID, model.root().type(), (ComponentInfo)info));
        }).thenCompose(r -> helper.safeContextEval(context, rootAddress, sub.writeToString())).exceptionally(this::handleException).thenRun(() -> {
            if (this.warnings.isEmpty()) {
                this.callback.onReturn(List.of());
            } else {
                this.callback.onError(List.of());
            }
        });
    }

    private List<Value> handleException(Throwable ex) {
        if (ex instanceof CompletionException) {
            CompletionException ce = (CompletionException)ex;
            return this.handleException(ce.getCause());
        }
        if (ex instanceof CallExecutionException) {
            CallExecutionException err = (CallExecutionException)ex;
            this.warnings.addAll(err.error().message().lines().toList());
            return List.of(err.error());
        }
        return List.of();
    }

    public static class Provider
    implements FileHandler.Provider {
        public Optional<FileHandler> createHandler(PraxisProject project, ExecutionLevel level, ExecutionElement.File element) {
            FileObject file = element.file();
            if (file.hasExt("pxr")) {
                if (level != ExecutionLevel.BUILD) {
                    throw new IllegalArgumentException("PXR files must be in build level");
                }
                try {
                    DataObject dob = DataObject.find((FileObject)file);
                    if (dob instanceof PXRDataObject) {
                        return Optional.of(new PXRFileHandler(project, (PXRDataObject)dob));
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
            return Optional.empty();
        }
    }
}

