/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.praxislive.ide.pxr.Bundle;
import org.praxislive.ide.pxr.SaveAsTemplateWizard;
import org.praxislive.ide.pxr.SaveAsTemplateWizardPanel1;

final class SaveAsTemplateVisualPanel1
extends JPanel
implements DocumentListener {
    private final SaveAsTemplateWizardPanel1 wizardPanel;
    private final FileChooserBuilder fileChooser;
    private FileObject location;
    private JButton browseButton;
    private JTextField fileField;
    private JLabel fileLabel;
    private JCheckBox librariesCheckbox;
    private JTextField locationField;
    private JLabel locationLabel;
    private JTextField nameField;
    private JLabel nameLabel;

    SaveAsTemplateVisualPanel1(SaveAsTemplateWizardPanel1 wizardPanel) {
        this.wizardPanel = wizardPanel;
        this.initComponents();
        SaveAsTemplateWizard wizard = wizardPanel.getWizard();
        this.location = wizard.getDefaultDestination();
        this.fileChooser = new FileChooserBuilder(SaveAsTemplateVisualPanel1.class).setDirectoriesOnly(true).setApproveText(Bundle.SaveAsTemplateVisualPanel1_fileSelect());
        this.locationField.setText(this.location.getPath());
        this.fileField.setText(this.location.toString());
        this.nameField.setText(wizard.getSuggestedFileName());
        this.nameField.getDocument().addDocumentListener(this);
        if (wizard.hasLibraries()) {
            this.librariesCheckbox.setEnabled(true);
            this.librariesCheckbox.setSelected(wizard.mightUseLibraries());
        } else {
            this.librariesCheckbox.setEnabled(false);
            this.librariesCheckbox.setSelected(false);
        }
    }

    @Override
    public String getName() {
        return Bundle.SaveAsTemplateVisualPanel1_name();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.update();
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.locationLabel = new JLabel();
        this.fileLabel = new JLabel();
        this.nameField = new JTextField();
        this.locationField = new JTextField();
        this.browseButton = new JButton();
        this.fileField = new JTextField();
        this.librariesCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(SaveAsTemplateVisualPanel1.class, (String)"PXGExportVisualPanel1.nameLabel.text_1"));
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(SaveAsTemplateVisualPanel1.class, (String)"PXGExportVisualPanel1.locationLabel.text_1"));
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(SaveAsTemplateVisualPanel1.class, (String)"PXGExportVisualPanel1.fileLabel.text_1"));
        this.nameField.setText(NbBundle.getMessage(SaveAsTemplateVisualPanel1.class, (String)"PXGExportVisualPanel1.nameField.text_1"));
        this.locationField.setEditable(false);
        this.locationField.setText(NbBundle.getMessage(SaveAsTemplateVisualPanel1.class, (String)"PXGExportVisualPanel1.locationField.text_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(SaveAsTemplateVisualPanel1.class, (String)"PXGExportVisualPanel1.browseButton.text_1"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveAsTemplateVisualPanel1.this.browseButtonActionPerformed(evt);
            }
        });
        this.fileField.setEditable(false);
        this.fileField.setText(NbBundle.getMessage(SaveAsTemplateVisualPanel1.class, (String)"PXGExportVisualPanel1.fileField.text_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.librariesCheckbox, (String)NbBundle.getMessage(SaveAsTemplateVisualPanel1.class, (String)"PXGExportVisualPanel1.librariesCheckbox.text"));
        this.librariesCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveAsTemplateVisualPanel1.this.librariesCheckboxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fileLabel).addComponent(this.locationLabel).addComponent(this.nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameField).addGroup(layout.createSequentialGroup().addComponent(this.locationField, -1, 306, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addComponent(this.fileField))).addGroup(layout.createSequentialGroup().addComponent(this.librariesCheckbox).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationLabel).addComponent(this.locationField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLabel).addComponent(this.fileField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.librariesCheckbox).addGap(124, 124, 124)));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File loc = this.fileChooser.showOpenDialog();
        if (loc != null) {
            this.location = FileUtil.toFileObject((File)loc);
            this.locationField.setText(this.location.getPath());
            this.update();
        }
    }

    private void librariesCheckboxActionPerformed(ActionEvent evt) {
        this.update();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.update();
    }

    FileObject getDestinationFolder() {
        return this.location;
    }

    String getFileName() {
        return this.nameField.getText();
    }

    boolean includeLibraries() {
        return this.librariesCheckbox.isSelected();
    }

    private void update() {
        Object name = this.nameField.getText();
        if (!((String)name).isEmpty() && !((String)name).endsWith(".pxx")) {
            name = (String)name + ".pxx";
        }
        this.fileField.setText(this.locationField.getText() + File.separator + (String)name);
        this.wizardPanel.validate();
    }
}

