/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.praxislive.ide.pxr.Bundle;
import org.praxislive.ide.pxr.SaveAsTemplateVisualPanel1;
import org.praxislive.ide.pxr.SaveAsTemplateWizard;

class SaveAsTemplateWizardPanel1
implements WizardDescriptor.Panel<WizardDescriptor> {
    private final ChangeSupport cs;
    private final SaveAsTemplateWizard wizard;
    private SaveAsTemplateVisualPanel1 component;
    private boolean valid;
    private WizardDescriptor wiz;
    private FileObject destination;
    private String filename;
    private boolean includeLibs;

    SaveAsTemplateWizardPanel1(SaveAsTemplateWizard exporter) {
        this.wizard = exporter;
        this.cs = new ChangeSupport((Object)this);
    }

    public SaveAsTemplateVisualPanel1 getComponent() {
        if (this.component == null) {
            this.component = new SaveAsTemplateVisualPanel1(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    public void readSettings(WizardDescriptor wiz) {
        this.wiz = wiz;
    }

    public void storeSettings(WizardDescriptor wiz) {
        wiz.putProperty("folder", (Object)this.destination);
        wiz.putProperty("filename", (Object)this.filename);
        wiz.putProperty("libraries", (Object)this.includeLibs);
    }

    SaveAsTemplateWizard getWizard() {
        return this.wizard;
    }

    void validate() {
        if (this.component == null) {
            return;
        }
        this.destination = null;
        this.filename = null;
        this.includeLibs = false;
        boolean nowValid = false;
        FileObject dest = this.component.getDestinationFolder();
        String err = null;
        Object name = this.component.getFileName();
        if (!((String)name).isEmpty()) {
            if (dest == null || !dest.isFolder() || !dest.canWrite()) {
                err = Bundle.SaveAsTemplateWizard_nonWritableDirectory();
            } else {
                if (!((String)name).endsWith(".pxx")) {
                    name = (String)name + ".pxx";
                }
                if (dest.getFileObject((String)name) == null) {
                    this.destination = dest;
                    this.filename = name;
                    this.includeLibs = this.component.includeLibraries();
                    nowValid = true;
                } else {
                    err = Bundle.SaveAsTemplateWizard_fileExists();
                }
            }
        }
        this.wiz.putProperty("WizardPanel_errorMessage", (Object)err);
        this.valid = nowValid;
        this.cs.fireChange();
    }
}

