/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openide.awt.Actions;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.util.Utilities;
import org.praxislive.ide.core.api.Syncable;
import org.praxislive.ide.model.RootProxy;
import org.praxislive.ide.pxr.Bundle;
import org.praxislive.ide.pxr.api.ActionSupport;
import org.praxislive.ide.pxr.spi.RootEditor;

class TableRootEditor
implements RootEditor {
    private final RootProxy root;
    private final EditorPanel editorComponent;
    private final ExplorerManager baseEM;
    private final ExplorerManager tableEM;
    private final ExplorerSync explorerSync;
    private final Set<Syncable> syncables;
    private final WeakHashMap<Node, TableNode> tableNodeCache;
    private final Action addAction;
    private final Action copyAction;
    private final Action deleteAction;
    private final Action duplicateAction;
    private final Action pasteAction;
    private final Action sharedCodeAction;

    TableRootEditor(RootProxy root, RootEditor.Context context, List<String> properties) {
        this.root = root;
        this.baseEM = context.explorerManager();
        this.tableEM = new ExplorerManager();
        this.explorerSync = new ExplorerSync();
        this.syncables = new HashSet<Syncable>();
        this.tableNodeCache = new WeakHashMap();
        this.addAction = Actions.forID((String)"PXR", (String)"org.praxislive.ide.pxr.AddChildAction");
        this.copyAction = ActionSupport.createCopyAction(this, this.baseEM);
        this.deleteAction = ActionSupport.createDeleteAction(this, this.baseEM);
        this.duplicateAction = ActionSupport.createDuplicateAction(this, this.baseEM);
        this.pasteAction = ActionSupport.createPasteAction(this, this.baseEM);
        this.sharedCodeAction = context.sharedCodeAction().orElse(null);
        this.editorComponent = new EditorPanel(this.initView(properties), this.tableEM);
        Node rootNode = root.getNodeDelegate();
        TableNode tableRoot = new TableNode(rootNode);
        this.tableNodeCache.put(rootNode, tableRoot);
        this.tableEM.setRootContext((Node)tableRoot);
        this.baseEM.addPropertyChangeListener((PropertyChangeListener)this.explorerSync);
        this.tableEM.addPropertyChangeListener((PropertyChangeListener)this.explorerSync);
    }

    private OutlineView initView(List<String> properties) {
        OutlineView ov = new OutlineView(Bundle.LBL_TableNodeColumn());
        for (String property : properties) {
            ov.addPropertyColumn(property, property);
        }
        ov.setDragSource(false);
        ov.setQuickSearchAllowed(false);
        return ov;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.editorComponent;
    }

    @Override
    public void dispose() {
        this.syncables.forEach(s -> s.removeKey((Object)this));
        this.syncables.clear();
        this.baseEM.removePropertyChangeListener((PropertyChangeListener)this.explorerSync);
        this.tableEM.setRootContext(Node.EMPTY);
        this.tableNodeCache.clear();
    }

    @Override
    public boolean requestFocus() {
        return this.editorComponent.view.requestFocusInWindow();
    }

    @Override
    public Set<RootEditor.ToolAction> supportedToolActions() {
        EnumSet<RootEditor.ToolAction> tools = EnumSet.allOf(RootEditor.ToolAction.class);
        tools.remove((Object)RootEditor.ToolAction.CONNECT);
        tools.remove((Object)RootEditor.ToolAction.DISCONNECT);
        return tools;
    }

    private void registerSyncable(Syncable syncable) {
        if (this.syncables.add(syncable)) {
            syncable.addKey((Object)this);
        }
    }

    private void clearSyncable(Syncable syncable) {
        this.syncables.remove(syncable);
        syncable.removeKey((Object)this);
    }

    private class ExplorerSync
    implements PropertyChangeListener {
        private boolean ignoreChanges;

        private ExplorerSync() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.ignoreChanges) {
                return;
            }
            try {
                this.ignoreChanges = true;
                if (evt.getSource() == TableRootEditor.this.baseEM) {
                    this.syncFromBaseEM();
                } else {
                    this.syncFromTableEM();
                }
            }
            catch (PropertyVetoException propertyVetoException) {
            }
            finally {
                this.ignoreChanges = false;
            }
        }

        private void syncFromBaseEM() throws PropertyVetoException {
            Node context = TableRootEditor.this.baseEM.getExploredContext();
            Node[] selection = TableRootEditor.this.baseEM.getSelectedNodes();
            TableNode tableContext = TableRootEditor.this.tableNodeCache.get(context);
            if (tableContext == null) {
                return;
            }
            TableNode[] tableSelection = (TableNode[])Stream.of(selection).map(TableRootEditor.this.tableNodeCache::get).filter(n -> n != null).toArray(TableNode[]::new);
            TableRootEditor.this.tableEM.setExploredContextAndSelection((Node)tableContext, (Node[])tableSelection);
        }

        private void syncFromTableEM() throws PropertyVetoException {
            Node[] selection = TableRootEditor.this.tableEM.getSelectedNodes();
            Node context = this.findContext(selection);
            if (context instanceof TableNode) {
                TableNode tableContext = (TableNode)context;
                Node baseContext = tableContext.getOriginal();
                Node[] baseSelection = (Node[])Stream.of(selection).filter(TableNode.class::isInstance).map(TableNode.class::cast).map(TableNode::getOriginal).toArray(Node[]::new);
                TableRootEditor.this.baseEM.setExploredContextAndSelection(baseContext, baseSelection);
            }
        }

        private Node findContext(Node[] selection) {
            Node root = TableRootEditor.this.tableEM.getRootContext();
            if (selection.length == 0) {
                return root;
            }
            if (selection.length == 1) {
                Node n = selection[0];
                Node c = n.isLeaf() ? n.getParentNode() : n;
                return c == null ? root : c;
            }
            Node p = selection[0].getParentNode();
            if (p == null) {
                return root;
            }
            for (int i = 1; i < selection.length; ++i) {
                if (selection[i].getParentNode() == p) continue;
                return root;
            }
            return p;
        }
    }

    private class EditorPanel
    extends JPanel
    implements ExplorerManager.Provider {
        private final OutlineView view;
        private final ExplorerManager explorerManager;

        private EditorPanel(OutlineView view, ExplorerManager explorerManager) {
            this.view = view;
            this.explorerManager = explorerManager;
            this.setLayout(new BorderLayout());
            this.add((Component)view, "Center");
            ActionMap am = view.getOutline().getActionMap();
            am.put("delete", TableRootEditor.this.deleteAction);
            am.put("copy-to-clipboard", TableRootEditor.this.copyAction);
            am.put("paste-from-clipboard", TableRootEditor.this.pasteAction);
            am.put("duplicate", TableRootEditor.this.duplicateAction);
            this.removeViewCopy(view.getOutline().getInputMap(0));
            this.removeViewCopy(view.getOutline().getInputMap(1));
        }

        private void removeViewCopy(InputMap map) {
            if (Utilities.isMac()) {
                map.put(KeyStroke.getKeyStroke(67, 256), "none");
            } else {
                map.put(KeyStroke.getKeyStroke(67, 128), "none");
            }
            map.put(KeyStroke.getKeyStroke("COPY"), "none");
        }

        public ExplorerManager getExplorerManager() {
            return this.explorerManager;
        }
    }

    private class TableNode
    extends FilterNode {
        private final Syncable syncable;

        TableNode(Node original) {
            super(original, (Children)(original.isLeaf() ? FilterNode.Children.LEAF : new TableChildren(original)));
            this.syncable = (Syncable)original.getLookup().lookup(Syncable.class);
            if (this.syncable != null) {
                TableRootEditor.this.registerSyncable(this.syncable);
                this.addNodeListener((NodeListener)new NodeAdapter(){

                    public void nodeDestroyed(NodeEvent ev) {
                        TableRootEditor.this.clearSyncable(TableNode.this.syncable);
                    }
                });
            }
        }

        protected PropertyChangeListener createPropertyChangeListener() {
            return new FilterNode.PropertyChangeAdapter(this){

                protected void propertyChange(FilterNode fn, PropertyChangeEvent ev) {
                    if (TableRootEditor.this.editorComponent.view.getOutline().isEditing()) {
                        return;
                    }
                    super.propertyChange(fn, ev);
                }
            };
        }

        public Action[] getActions(boolean context) {
            ArrayList<Action> actions = new ArrayList<Action>();
            if (!this.isLeaf()) {
                actions.add(TableRootEditor.this.addAction);
                actions.add(null);
            }
            actions.addAll(Arrays.asList(super.getActions(context)));
            actions.add(null);
            actions.add(TableRootEditor.this.copyAction);
            actions.add(TableRootEditor.this.duplicateAction);
            if (!this.isLeaf()) {
                actions.add(TableRootEditor.this.pasteAction);
            }
            actions.add(null);
            actions.add(TableRootEditor.this.deleteAction);
            if (TableRootEditor.this.sharedCodeAction != null) {
                actions.add(null);
                actions.add(TableRootEditor.this.sharedCodeAction);
            }
            return (Action[])actions.toArray(Action[]::new);
        }

        protected Node getOriginal() {
            return super.getOriginal();
        }
    }

    private class TableChildren
    extends FilterNode.Children {
        TableChildren(Node parent) {
            super(parent);
        }

        protected Node[] createNodes(Node key) {
            TableNode tableNode = new TableNode(key);
            TableRootEditor.this.tableNodeCache.put(key, tableNode);
            return new Node[]{tableNode};
        }
    }
}

