/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.EventQueue;
import java.awt.Image;
import java.net.URI;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.praxislive.core.ComponentType;
import org.praxislive.ide.components.api.Icons;
import org.praxislive.ide.pxr.PXRWizardIterator;
import org.praxislive.project.GraphModel;

public class TemplateDataObject
extends MultiDataObject {
    static final String MIME_TYPE = "text/x-praxis-root-template";
    static final String ACTION_PATH = "Loaders/text/text/x-praxis-root-template/Actions";
    private static final RequestProcessor RP = new RequestProcessor();
    String rootID;
    private Image icon;
    private DataNodeImpl node;

    public TemplateDataObject(FileObject file, MultiFileLoader loader) throws DataObjectExistsException {
        super(file, loader);
        CookieSet cookies = this.getCookieSet();
        cookies.add((Node.Cookie)DataEditorSupport.create((DataObject)this, (MultiDataObject.Entry)this.getPrimaryEntry(), (CookieSet)cookies));
        cookies.add((Node.Cookie)new PXRWizardIterator());
        this.icon = Icons.defaultIcon();
        this.updateIconAndType();
        file.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileChanged(FileEvent fe) {
                TemplateDataObject.this.updateIconAndType();
            }
        });
    }

    protected Node createNodeDelegate() {
        this.node = new DataNodeImpl(this, this.getLookup());
        return this.node;
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    private void updateIconAndType() {
        FileObject file = this.getPrimaryFile();
        RP.execute(() -> {
            try {
                String script = file.asText();
                GraphModel model = GraphModel.parse((URI)file.getParent().toURI(), (String)script);
                EventQueue.invokeLater(() -> {
                    this.icon = Icons.getIcon((ComponentType)model.root().type());
                    this.rootID = model.root().id();
                    if (this.node != null) {
                        this.node.updateIcon();
                    }
                });
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
    }

    private static class DataNodeImpl
    extends DataNode {
        TemplateDataObject dob;

        private DataNodeImpl(TemplateDataObject dob, Lookup lookup) {
            super((DataObject)dob, Children.LEAF, lookup);
            this.dob = dob;
        }

        private void updateIcon() {
            this.fireIconChange();
        }

        public Image getIcon(int type) {
            return this.dob.icon;
        }
    }
}

