/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.editors;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Iterator;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.praxislive.core.Value;
import org.praxislive.core.syntax.Token;
import org.praxislive.core.syntax.Tokenizer;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PNumber;
import org.praxislive.core.types.PString;
import org.praxislive.ide.properties.EditorSupport;
import org.praxislive.ide.properties.PraxisProperty;
import org.praxislive.ide.properties.SyntaxUtils;
import org.praxislive.ide.pxr.editors.ArrayCustomEditor;

public class ArrayEditor
extends EditorSupport
implements PraxisProperty.SubCommandEditor,
ExPropertyEditor {
    private String text;
    private PropertyEnv env;

    public void setValue(Object value) {
        try {
            super.setValue(PArray.from((Value)((Value)value)).get());
            this.text = null;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void setAsText(String text) throws IllegalArgumentException {
        Iterator tokens = new Tokenizer((CharSequence)text).iterator();
        super.setValue((Object)this.parseTokens(tokens, false));
        this.text = text;
    }

    public String getAsText() {
        if (this.text != null) {
            return this.text;
        }
        return this.buildValueText(false);
    }

    public String getDisplayName() {
        return "Array Editor";
    }

    public void setFromCommand(String command) throws Exception {
        Iterator tokens = new Tokenizer((CharSequence)command).iterator();
        Token cmd = (Token)tokens.next();
        if (cmd.getType() != Token.Type.PLAIN || !"array".equals(cmd.getText())) {
            throw new IllegalArgumentException("Not array command");
        }
        super.setValue((Object)this.parseTokens(tokens, false));
        this.text = null;
    }

    public String[] getSupportedCommands() {
        return new String[]{"array"};
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new ArrayCustomEditor((PropertyEditor)((Object)this), this.env);
    }

    public String getPraxisInitializationString() {
        return this.buildValueText(true);
    }

    private PArray parseTokens(Iterator<Token> tokens, boolean allowEOL) {
        if (!tokens.hasNext()) {
            return PArray.EMPTY;
        }
        ArrayList<Object> args = new ArrayList<Object>();
        boolean EOLreached = false;
        while (tokens.hasNext()) {
            if (EOLreached && !allowEOL) {
                throw new IllegalArgumentException("Extra tokens found after EOL");
            }
            Token tk = tokens.next();
            switch (tk.getType()) {
                case PLAIN: {
                    args.add(this.parsePlainToken(tk.getText()));
                    break;
                }
                case QUOTED: 
                case BRACED: {
                    args.add(PString.of((String)tk.getText()));
                    break;
                }
                case SUBCOMMAND: {
                    throw new IllegalArgumentException("SubCommand token not allowed in array");
                }
                case EOL: {
                    EOLreached = true;
                }
            }
        }
        return PArray.of(args);
    }

    private Value parsePlainToken(String text) {
        char c = text.charAt(0);
        if (c == '.') {
            throw new IllegalArgumentException("Can't parse relative address");
        }
        PNumber ret = null;
        if (Character.isDigit(c)) {
            try {
                ret = PNumber.parse((String)text);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (c == '-' && text.length() > 1 && Character.isDigit(text.charAt(1))) {
            try {
                ret = PNumber.parse((String)text);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ret == null) {
            return PString.of((String)text);
        }
        return ret;
    }

    private String buildValueText(boolean asCommand) {
        try {
            PArray array = (PArray)PArray.from((Value)((Value)this.getValue())).get();
            StringBuilder sb = new StringBuilder();
            if (asCommand) {
                sb.append("[array ");
            }
            int total = array.size();
            for (int i = 0; i < total; ++i) {
                Value arg = array.get(i);
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(SyntaxUtils.escape((String)arg.toString()));
            }
            if (asCommand) {
                sb.append("]");
            }
            return sb.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

