/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.editors;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableModel;
import org.openide.util.Exceptions;
import org.praxislive.core.ValueFormatException;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PString;

class ArrayTable
extends JTable {
    private static final TrackerTransferHandler TRANSFER_HANDLER = new TrackerTransferHandler();

    public ArrayTable() {
        super(1, 1);
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setSurrendersFocusOnKeystroke(true);
        this.setTransferHandler(TRANSFER_HANDLER);
        this.setTableHeader(null);
        this.setShowGrid(true);
        this.initActions();
    }

    private void initActions() {
        Action[] actions = new Action[]{new DeleteAction()};
        InputMap im = this.getInputMap();
        ActionMap am = this.getActionMap();
        for (Action action : actions) {
            String name = (String)action.getValue("Name");
            im.put((KeyStroke)action.getValue("AcceleratorKey"), name);
            am.put(name, action);
        }
        am.put("copy-to-clipboard", new RedirectAction(this, TransferHandler.getCopyAction()));
        am.put("paste-from-clipboard", new RedirectAction(this, TransferHandler.getPasteAction()));
        this.wrapTab();
    }

    private void wrapTab() {
        Object key = this.getInputMap(1).get(KeyStroke.getKeyStroke(9, 0));
        Action action = this.getActionMap().get(key);
        if (action != null) {
            this.getActionMap().put(key, new NextCellAction(action));
        }
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        if (e instanceof KeyEvent && this.suppressKeyEvent((KeyEvent)e)) {
            return false;
        }
        return super.editCellAt(row, column, e);
    }

    private boolean suppressKeyEvent(KeyEvent ke) {
        int mask = 384;
        return (ke.getModifiersEx() & mask) != 0;
    }

    private static class TrackerTransferHandler
    extends TransferHandler {
        private TrackerTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof ArrayTable) {
                ArrayTable table = (ArrayTable)c;
                int row = table.getSelectedRow();
                int rowCount = table.getSelectedRowCount();
                if (row < 0 || rowCount < 1) {
                    return null;
                }
                ArrayList<PString> list = new ArrayList<PString>(rowCount);
                for (int i = 0; i < rowCount; ++i) {
                    Object o = table.getValueAt(row + i, 0);
                    list.add(o == null ? PString.EMPTY : PString.of((Object)o));
                }
                return new StringSelection(PArray.of(list).toString());
            }
            return null;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDataFlavorSupported(DataFlavor.stringFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (support.getComponent() instanceof ArrayTable && this.canImport(support)) {
                try {
                    int rd;
                    ArrayTable table = (ArrayTable)support.getComponent();
                    int row = table.getSelectedRow();
                    int rowCount = table.getSelectedRowCount();
                    if (row < 0 || rowCount != 1) {
                        return false;
                    }
                    String data = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    PArray values = PArray.parse((String)data);
                    for (int r = 0; r < values.size() && (rd = r + row) < table.getRowCount(); ++r) {
                        table.setValueAt(values.get(r).toString(), rd, 0);
                    }
                }
                catch (UnsupportedFlavorException | IOException | ValueFormatException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return false;
        }
    }

    private class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super("delete");
            this.putValue("ShortDescription", "Delete");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = ArrayTable.this.getSelectedRow();
            int rowCount = ArrayTable.this.getSelectedRowCount();
            if (row < 0 || rowCount < 1) {
                return;
            }
            for (int r = row + rowCount - 1; r >= row; --r) {
                ((DefaultTableModel)ArrayTable.this.getModel()).removeRow(r);
                ArrayTable.this.getSelectionModel().setSelectionInterval(r - 1, r - 1);
            }
        }
    }

    private class RedirectAction
    extends AbstractAction {
        private final ArrayTable table;
        private final Action action;

        private RedirectAction(ArrayTable table, Action action) {
            super("redirect-" + String.valueOf(action.getValue("Name")));
            this.table = table;
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            e = new ActionEvent(this.table, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers());
            this.action.actionPerformed(e);
        }
    }

    private class NextCellAction
    extends AbstractAction {
        private final Action wrapped;

        public NextCellAction(Action wrapped) {
            super("next-cell");
            this.wrapped = wrapped;
            this.putValue("ShortDescription", "Next Cell");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(9, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = ArrayTable.this.getSelectedRow() + 1;
            if (row >= ArrayTable.this.getRowCount()) {
                ((DefaultTableModel)ArrayTable.this.getModel()).addRow(new Object[]{""});
            }
            this.wrapped.actionPerformed(e);
        }
    }
}

