/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.editors;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.types.PString;
import org.praxislive.ide.model.ComponentProxy;
import org.praxislive.ide.model.RootProxy;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.pxr.PXRRootRegistry;
import org.praxislive.ide.pxr.editors.ControlAddressEditor;

class ControlAddressCustomEditor
extends JPanel
implements ExplorerManager.Provider {
    private static final Set<String> SYS_CTRLS = new HashSet<String>();
    private static final Logger LOG;
    private ControlAddress current;
    private ComponentProxy exploredComponent;
    private final ExplorerManager em;
    private final PropertyEnv env;
    private final ControlAddressEditor editor;
    private final Listener listener;
    private final DefaultListModel listModel;
    private JTextField addressField;
    private JButton clearButton;
    private JList controlList;
    private JScrollPane nodeBrowser;
    private JToggleButton systemToggleButton;
    private JToolBar toolBar;

    ControlAddressCustomEditor(ControlAddressEditor editor, ControlAddress current, PropertyEnv env) {
        Node node;
        this.initComponents();
        if (current != null) {
            this.addressField.setText(current.toString());
        }
        this.current = current;
        this.env = env;
        this.editor = editor;
        this.em = new ExplorerManager();
        this.listener = new Listener();
        this.listModel = new DefaultListModel();
        this.controlList.setModel(this.listModel);
        this.em.setRootContext((Node)new AbstractNode((Children)new RootsChildren(editor.project), Lookup.EMPTY));
        if (current != null && (node = this.findNodeFromAddress(current)) != null) {
            try {
                this.em.setSelectedNodes(new Node[]{node});
                this.refreshComponent((ComponentProxy)node.getLookup().lookup(ComponentProxy.class));
                this.controlList.setSelectedValue(current.controlID(), true);
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        env.addVetoableChangeListener((VetoableChangeListener)this.listener);
        this.addressField.getDocument().addDocumentListener(this.listener);
        this.em.addPropertyChangeListener((PropertyChangeListener)this.listener);
        this.controlList.addListSelectionListener(this.listener);
        this.controlList.addMouseListener(this.listener);
        this.initNodeBrowser();
    }

    private void initNodeBrowser() {
        BeanTreeView view = (BeanTreeView)this.nodeBrowser;
        view.setRootVisible(false);
        view.setSelectionMode(1);
        view.setPopupAllowed(false);
    }

    private Node findNodeFromAddress(ControlAddress address) {
        LOG.log(Level.FINEST, "Searching for node that matches {0}", address);
        ComponentAddress cmp = address.component();
        String[] parts = new String[cmp.depth()];
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = cmp.componentID(i);
        }
        try {
            return NodeOp.findPath((Node)this.em.getRootContext(), (String[])parts);
        }
        catch (NodeNotFoundException ex) {
            LOG.log(Level.FINEST, "Node not found", ex);
            return null;
        }
    }

    private void initComponents() {
        this.addressField = new JTextField();
        this.nodeBrowser = new BeanTreeView();
        JScrollPane listScroll = new JScrollPane();
        this.controlList = new JList();
        this.toolBar = new JToolBar();
        this.clearButton = new JButton();
        this.systemToggleButton = new JToggleButton();
        this.addressField.setText(NbBundle.getMessage(ControlAddressCustomEditor.class, (String)"ControlAddressCustomEditor.addressField.text"));
        this.nodeBrowser.setPreferredSize(new Dimension(150, 200));
        this.controlList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        listScroll.setViewportView(this.controlList);
        this.toolBar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/org/praxislive/ide/pxr/resources/clear.png")));
        this.clearButton.setText(NbBundle.getMessage(ControlAddressCustomEditor.class, (String)"ControlAddressCustomEditor.clearButton.text"));
        this.clearButton.setFocusable(false);
        this.clearButton.setHorizontalTextPosition(0);
        this.clearButton.setVerticalTextPosition(3);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlAddressCustomEditor.this.clearButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.clearButton);
        this.systemToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/praxislive/ide/pxr/resources/system.png")));
        this.systemToggleButton.setText(NbBundle.getMessage(ControlAddressCustomEditor.class, (String)"ControlAddressCustomEditor.systemToggleButton.text"));
        this.systemToggleButton.setFocusable(false);
        this.systemToggleButton.setHorizontalTextPosition(0);
        this.systemToggleButton.setVerticalTextPosition(3);
        this.systemToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlAddressCustomEditor.this.systemToggleButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.systemToggleButton);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.nodeBrowser, -1, 233, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(listScroll, -1, 137, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.addressField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toolBar, -2, -1, -2).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.addressField, -2, -1, -2).addComponent(this.toolBar, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.nodeBrowser, -1, -1, Short.MAX_VALUE).addComponent(listScroll, -2, 0, Short.MAX_VALUE)).addContainerGap()));
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.addressField.setText("");
    }

    private void systemToggleButtonActionPerformed(ActionEvent evt) {
        this.refreshList();
    }

    public ExplorerManager getExplorerManager() {
        return this.em;
    }

    private void refreshComponent(ComponentProxy cmp) {
        if (this.exploredComponent == cmp) {
            return;
        }
        this.exploredComponent = cmp;
        this.refreshList();
    }

    private void refreshList() {
        ComponentProxy cmp = this.exploredComponent;
        this.listModel.clear();
        if (cmp != null) {
            boolean sys = this.systemToggleButton.isSelected();
            for (String id : cmp.getInfo().controls()) {
                if (!sys && SYS_CTRLS.contains(id)) continue;
                this.listModel.addElement(id);
            }
        }
    }

    static {
        SYS_CTRLS.add("info");
        SYS_CTRLS.add("add-child");
        SYS_CTRLS.add("children");
        SYS_CTRLS.add("connect");
        SYS_CTRLS.add("connections");
        SYS_CTRLS.add("disconnect");
        SYS_CTRLS.add("remove-child");
        SYS_CTRLS.add("code");
        LOG = Logger.getLogger(ControlAddressCustomEditor.class.getName());
    }

    private class Listener
    extends MouseAdapter
    implements DocumentListener,
    VetoableChangeListener,
    PropertyChangeListener,
    ListSelectionListener {
        private boolean ignore;

        private Listener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent e) {
            if (this.ignore) {
                return;
            }
            String txt = ControlAddressCustomEditor.this.addressField.getText();
            if (txt.isEmpty()) {
                ControlAddressCustomEditor.this.current = null;
                try {
                    ControlAddressCustomEditor.this.em.setSelectedNodes(new Node[0]);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                ControlAddressCustomEditor.this.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            } else {
                try {
                    ControlAddressCustomEditor.this.current = ControlAddress.of((String)ControlAddressCustomEditor.this.addressField.getText());
                    ControlAddressCustomEditor.this.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
                }
                catch (Exception ex) {
                    ControlAddressCustomEditor.this.env.setState(PropertyEnv.STATE_INVALID);
                }
            }
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (evt.getNewValue().equals(PropertyEnv.STATE_VALID)) {
                if (ControlAddressCustomEditor.this.current == null) {
                    ControlAddressCustomEditor.this.editor.setValue(PString.EMPTY);
                } else {
                    ControlAddressCustomEditor.this.editor.setValue(ControlAddressCustomEditor.this.current);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                LOG.finest("Node selection changed");
                Node[] nodes = ControlAddressCustomEditor.this.em.getSelectedNodes();
                ComponentProxy cmp = null;
                if (nodes.length == 1) {
                    cmp = (ComponentProxy)nodes[0].getLookup().lookup(ComponentProxy.class);
                }
                ControlAddressCustomEditor.this.refreshComponent(cmp);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Object sel = ControlAddressCustomEditor.this.controlList.getSelectedValue();
            if (sel == null) {
                return;
            }
            String id = sel.toString();
            if (ControlAddressCustomEditor.this.exploredComponent != null) {
                ControlAddressCustomEditor.this.current = ControlAddress.of((ComponentAddress)ControlAddressCustomEditor.this.exploredComponent.getAddress(), (String)id);
                this.ignore = true;
                ControlAddressCustomEditor.this.addressField.setText(ControlAddressCustomEditor.this.current.toString());
                ControlAddressCustomEditor.this.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
                this.ignore = false;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int index = ControlAddressCustomEditor.this.controlList.locationToIndex(e.getPoint());
                if (index < 0) {
                    return;
                }
                Object id = ControlAddressCustomEditor.this.controlList.getModel().getElementAt(index);
                JRootPane rpane = SwingUtilities.getRootPane(ControlAddressCustomEditor.this.controlList);
                JButton button = rpane.getDefaultButton();
                if (id instanceof String && button != null) {
                    ControlAddressCustomEditor.this.current = ControlAddress.of((ComponentAddress)ControlAddressCustomEditor.this.exploredComponent.getAddress(), (String)id.toString());
                    button.doClick();
                    e.consume();
                }
            }
        }
    }

    private static class RootsChildren
    extends Children.Keys<RootProxy> {
        private RootsChildren(PraxisProject project) {
            PXRRootRegistry reg;
            if (project != null && (reg = (PXRRootRegistry)project.getLookup().lookup(PXRRootRegistry.class)) != null) {
                this.setKeys(reg.findAll());
            }
        }

        protected Node[] createNodes(RootProxy key) {
            return new Node[]{new ComponentNode(key.getNodeDelegate())};
        }
    }

    private static class ComponentChildren
    extends FilterNode.Children {
        private ComponentChildren(Node node) {
            super(node);
        }

        protected Node copyNode(Node node) {
            return new ComponentNode(node);
        }
    }

    private static class ComponentNode
    extends FilterNode {
        private ComponentNode(Node node) {
            super(node, (Children)(node.getChildren() == FilterNode.Children.LEAF ? FilterNode.Children.LEAF : new ComponentChildren(node)));
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }

        public Action getPreferredAction() {
            return null;
        }
    }
}

