/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.editors;

import java.awt.Component;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.praxislive.core.ArgumentInfo;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Value;
import org.praxislive.core.ValueFormatException;
import org.praxislive.core.types.PString;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.properties.EditorSupport;
import org.praxislive.ide.properties.PraxisProperty;
import org.praxislive.ide.pxr.editors.ControlAddressCustomEditor;

public class ControlAddressEditor
extends EditorSupport
implements ExPropertyEditor {
    final PraxisProject project;
    private PropertyEnv env;
    private final boolean allowEmpty;

    ControlAddressEditor(PraxisProperty property, ArgumentInfo info) {
        Object p = property.getValue("project");
        this.project = p instanceof PraxisProject ? (PraxisProject)p : null;
        this.allowEmpty = info.properties().getBoolean("allow-empty", false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAsText(String text) throws IllegalArgumentException {
        String val = text.trim();
        if (val.isEmpty()) {
            if (!this.allowEmpty) throw new IllegalArgumentException("Property doesn't support empty value");
            this.setValue(PString.EMPTY);
            return;
        }
        try {
            this.setValue(ControlAddress.parse((String)val));
            return;
        }
        catch (ValueFormatException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private ControlAddress getAddress() {
        try {
            Value arg = (Value)this.getValue();
            if (arg.isEmpty()) {
                return null;
            }
            return (ControlAddress)ControlAddress.from((Value)arg).orElseThrow();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getPraxisInitializationString() {
        ControlAddress address = this.getAddress();
        if (address == null) {
            return "{}";
        }
        return address.toString();
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new ControlAddressCustomEditor(this, this.getAddress(), this.env);
    }

    public String getDisplayName() {
        return "Control Address Editor";
    }
}

