/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.editors;

import org.praxislive.core.ArgumentInfo;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Value;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PBoolean;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PNumber;
import org.praxislive.core.types.PResource;
import org.praxislive.core.types.PString;
import org.praxislive.ide.properties.PraxisProperty;
import org.praxislive.ide.pxr.editors.ArgumentEditor;
import org.praxislive.ide.pxr.editors.ArrayEditor;
import org.praxislive.ide.pxr.editors.BooleanEditor;
import org.praxislive.ide.pxr.editors.ControlAddressEditor;
import org.praxislive.ide.pxr.editors.FileListEditor;
import org.praxislive.ide.pxr.editors.MapEditor;
import org.praxislive.ide.pxr.editors.NumberEditor;
import org.praxislive.ide.pxr.editors.ResourceEditor;
import org.praxislive.ide.pxr.editors.StringEditor;

public class EditorManager {
    public static PraxisProperty.Editor getDefaultEditor(PraxisProperty property, ControlInfo info) {
        if (info.outputs().size() == 1) {
            return EditorManager.getDefaultEditor(property, (ArgumentInfo)info.outputs().get(0));
        }
        throw new UnsupportedOperationException("EditorManager cannot currently handle properties with multiple arguments.");
    }

    private static PraxisProperty.Editor getDefaultEditor(PraxisProperty property, ArgumentInfo info) {
        Class type = ((Value.Type)Value.Type.fromName((String)info.argumentType()).get()).asClass();
        if (PString.class.isAssignableFrom(type)) {
            return new StringEditor(property, info);
        }
        if (PNumber.class.isAssignableFrom(type)) {
            return new NumberEditor(property, info);
        }
        if (PBoolean.class.isAssignableFrom(type)) {
            return new BooleanEditor();
        }
        if (PResource.class.isAssignableFrom(type)) {
            return new ResourceEditor(property, info);
        }
        if (PArray.class.isAssignableFrom(type)) {
            return new ArrayEditor();
        }
        if (ControlAddress.class.isAssignableFrom(type)) {
            return new ControlAddressEditor(property, info);
        }
        if (PMap.class.isAssignableFrom(type)) {
            return new MapEditor(property, info);
        }
        return new ArgumentEditor(property, info);
    }

    public static boolean hasAdditionalEditors(PraxisProperty property, ControlInfo info) {
        if (info.outputs().size() == 1) {
            return EditorManager.hasAdditionalEditors(property, (ArgumentInfo)info.outputs().get(0));
        }
        throw new UnsupportedOperationException("EditorManager cannot currently handle properties with multiple arguments.");
    }

    private static boolean hasAdditionalEditors(PraxisProperty<?> property, ArgumentInfo info) {
        Class type = ((Value.Type)Value.Type.fromName((String)info.argumentType()).get()).asClass();
        if (PArray.class.isAssignableFrom(type)) {
            return true;
        }
        if (PMap.class.isAssignableFrom(type)) {
            return true;
        }
        return type.equals(Value.class);
    }

    public static PraxisProperty.Editor[] getAdditionalEditors(PraxisProperty property, ControlInfo info) {
        if (info.outputs().size() == 1) {
            return EditorManager.getAdditionalEditors(property, (ArgumentInfo)info.outputs().get(0));
        }
        throw new UnsupportedOperationException("EditorManager cannot currently handle properties with multiple arguments.");
    }

    private static PraxisProperty.Editor[] getAdditionalEditors(PraxisProperty<?> property, ArgumentInfo info) {
        Class type = ((Value.Type)Value.Type.fromName((String)info.argumentType()).get()).asClass();
        if (PArray.class.isAssignableFrom(type)) {
            return new PraxisProperty.Editor[]{new FileListEditor(property, info), new ArgumentEditor(property, info)};
        }
        if (PMap.class.isAssignableFrom(type)) {
            return new PraxisProperty.Editor[]{new ArgumentEditor(property, info)};
        }
        if (type.equals(Value.class)) {
            return new PraxisProperty.Editor[]{new ResourceEditor(property, info), new FileListEditor(property, info)};
        }
        return new PraxisProperty.Editor[0];
    }
}

