/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.editors;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.NbBundle;
import org.praxislive.ide.pxr.editors.FileListEditor;

class FileListCustomEditor
extends JPanel
implements VetoableChangeListener {
    private static final Logger LOG = Logger.getLogger(FileListCustomEditor.class.getName());
    private final URI base;
    private File directory;
    private final PropertyEnv env;
    private final FileListEditor editor;
    private JButton browseButton;
    private JTextField dirField;

    FileListCustomEditor(FileListEditor editor, URI base, File directory, PropertyEnv env) {
        this.initComponents();
        if (directory != null) {
            this.dirField.setText(directory.toString());
        }
        this.base = base;
        this.env = env;
        this.editor = editor;
        this.directory = directory;
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addVetoableChangeListener((VetoableChangeListener)this);
    }

    private void initComponents() {
        this.dirField = new JTextField();
        this.browseButton = new JButton();
        this.dirField.setEditable(false);
        this.dirField.setText(NbBundle.getMessage(FileListCustomEditor.class, (String)"FileListCustomEditor.dirField.text"));
        this.browseButton.setText(NbBundle.getMessage(FileListCustomEditor.class, (String)"FileListCustomEditor.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileListCustomEditor.this.browseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.dirField, -1, 309, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dirField, -2, -1, -2).addComponent(this.browseButton)).addContainerGap(259, Short.MAX_VALUE)));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File loc = null;
        if (this.directory != null) {
            loc = this.directory.getParentFile();
        }
        if (loc == null && this.base != null && "file".equals(this.base.getScheme())) {
            try {
                loc = new File(this.base);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FileChooserBuilder dlgBld = new FileChooserBuilder(FileListCustomEditor.class);
        if (loc != null) {
            dlgBld.setDefaultWorkingDirectory(loc).forceUseOfDefaultWorkingDirectory(true);
        }
        dlgBld.setDirectoriesOnly(true);
        dlgBld.setTitle("Choose Directory").setApproveText("OK");
        File file = dlgBld.showOpenDialog();
        if (file != null) {
            this.directory = file;
            this.dirField.setText(this.directory.toString());
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (this.directory != null) {
            try {
                LOG.fine("Setting directory to " + String.valueOf(this.directory));
                this.editor.setDirectory(this.directory);
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "Exception setting directory", ex);
            }
        }
    }
}

