/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.editors;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.praxislive.core.ArgumentInfo;
import org.praxislive.core.syntax.Token;
import org.praxislive.core.syntax.Tokenizer;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PResource;
import org.praxislive.ide.properties.EditorSupport;
import org.praxislive.ide.properties.PraxisProperty;
import org.praxislive.ide.properties.SyntaxUtils;
import org.praxislive.ide.pxr.editors.FileListCustomEditor;

public class FileListEditor
extends EditorSupport
implements PraxisProperty.SubCommandEditor,
ExPropertyEditor {
    private URI base;
    private File directory;
    private boolean setExternally;
    private PropertyEnv env;

    public FileListEditor(PraxisProperty<?> property, ArgumentInfo info) {
        Object dir = property.getValue("workingDir");
        this.base = dir instanceof File ? ((File)dir).toURI() : new File("").toURI();
    }

    public void setValue(Object value) {
        if (value == this.getValue()) {
            return;
        }
        super.setValue(value);
        this.setExternally = true;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    public String getAsText() {
        return null;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        if (this.setExternally) {
            gfx.setFont(gfx.getFont().deriveFont(2));
        }
        FontMetrics fm = gfx.getFontMetrics();
        gfx.drawString("[file-list ... ]", box.x, box.y + (box.height - fm.getHeight()) / 2 + fm.getAscent());
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new FileListCustomEditor(this, this.base, this.directory, this.env);
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
    }

    public String getPraxisInitializationString() {
        if (this.directory == null) {
            return "{}";
        }
        URI uri = this.directory.toURI();
        Object dirCode = (uri = this.base.relativize(uri)).isAbsolute() ? uri.toString() : "[file " + SyntaxUtils.escapeQuoted((String)uri.getPath()) + "]";
        return "[file-list " + (String)dirCode + "]";
    }

    public String[] getSupportedCommands() {
        return new String[]{"file-list"};
    }

    void setDirectory(File dir) throws Exception {
        super.setValue((Object)this.buildFileList(dir));
        this.directory = dir;
        this.setExternally = false;
    }

    public void setFromCommand(String command) throws Exception {
        Iterator tokens = new Tokenizer((CharSequence)command).iterator();
        Token cmd = (Token)tokens.next();
        if (cmd.getType() != Token.Type.PLAIN || !"file-list".equals(cmd.getText())) {
            throw new IllegalArgumentException("Not file-list command");
        }
        Token loc = (Token)tokens.next();
        File dir = switch (loc.getType()) {
            case Token.Type.SUBCOMMAND -> this.parseRelativeDirectory(loc);
            case Token.Type.PLAIN, Token.Type.QUOTED, Token.Type.BRACED -> this.parseAbsoluteDirectory(loc);
            default -> throw new IllegalArgumentException();
        };
        super.setValue((Object)this.buildFileList(dir));
        this.setExternally = false;
        this.directory = dir;
    }

    private File parseAbsoluteDirectory(Token loc) throws Exception {
        URI uri = new URI(loc.getText());
        if (uri.isAbsolute()) {
            return new File(uri);
        }
        throw new IllegalArgumentException("URI is not an absolute address");
    }

    private File parseRelativeDirectory(Token loc) throws Exception {
        Iterator tokens = new Tokenizer((CharSequence)loc.getText()).iterator();
        Token cmd = (Token)tokens.next();
        if (cmd.getType() != Token.Type.PLAIN || !"file".equals(cmd.getText())) {
            throw new IllegalArgumentException("Invalid subcommand in command");
        }
        Token file = (Token)tokens.next();
        switch (file.getType()) {
            case PLAIN: 
            case QUOTED: 
            case BRACED: {
                return this.resolveDirectory(file);
            }
        }
        throw new IllegalArgumentException("Invalid token type in [file command");
    }

    private PArray buildFileList(File dir) throws Exception {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("File does not refer to a directory.");
        }
        File[] files = dir.listFiles();
        ArrayList<PResource> uris = new ArrayList<PResource>();
        for (File f : files) {
            uris.add(PResource.of((URI)f.toURI()));
        }
        Collections.sort(uris);
        return PArray.of(uris);
    }

    private File resolveDirectory(Token file) throws Exception {
        URI path = this.base.resolve(new URI(null, null, file.getText(), null));
        return new File(path);
    }

    public String getDisplayName() {
        return "File List";
    }
}

