/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;
import org.openide.awt.HtmlRenderer;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.praxislive.core.ArgumentInfo;
import org.praxislive.core.Value;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PMap;
import org.praxislive.ide.properties.EditorSupport;
import org.praxislive.ide.properties.PraxisProperty;
import org.praxislive.ide.pxr.editors.StringCustomEditor;

public class StringEditor
extends EditorSupport
implements ExPropertyEditor {
    private static final String EMPTY_DEFAULT_STRING = "[default]";
    private static final String EDIT_AS_TEXT = "canEditAsText";
    private PropertyEnv env;
    private boolean emptyIsDefault;
    private boolean rewriteDefaultTag;
    private boolean limitToTags;
    private List<String> tags;

    public StringEditor(PraxisProperty<?> property, ArgumentInfo info) {
        if (property == null) {
            throw new NullPointerException();
        }
        PMap props = info.properties();
        this.emptyIsDefault = props.getBoolean("empty-is-default", false);
        Value tagArray = props.get("allowed-values");
        if (tagArray != null) {
            this.limitToTags = true;
        } else {
            tagArray = props.get("suggested-values");
        }
        if (tagArray != null) {
            this.createTagList(tagArray);
        }
    }

    private void createTagList(Value tagArray) {
        try {
            PArray arr = (PArray)PArray.from((Value)tagArray).orElseThrow();
            this.tags = new ArrayList<String>(arr.size());
            for (Value val : arr) {
                this.tags.add(val.toString());
            }
            if (this.emptyIsDefault && this.tags.contains("") && !this.tags.contains(EMPTY_DEFAULT_STRING)) {
                this.tags.remove("");
                this.tags.add(0, EMPTY_DEFAULT_STRING);
                this.rewriteDefaultTag = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getAttribute(String key) {
        if (this.tags != null && !this.limitToTags && EDIT_AS_TEXT.equals(key)) {
            return Boolean.TRUE;
        }
        return null;
    }

    public String[] getAttributeKeys() {
        return new String[]{EDIT_AS_TEXT};
    }

    public boolean isPaintable() {
        return this.emptyIsDefault && this.getAsText().isEmpty();
    }

    public void paintValue(Graphics g, Rectangle r) {
        Font font = g.getFont();
        FontMetrics fm = g.getFontMetrics(font);
        HtmlRenderer.renderHTML((String)"<font color=\"!textInactiveText\">[default]</font>", (Graphics)g, (int)r.x, (int)(r.y + (r.height - fm.getHeight()) / 2 + fm.getAscent()), (int)r.width, (int)r.height, (Font)g.getFont(), (Color)g.getColor(), (int)1, (boolean)true);
    }

    public String getDisplayName() {
        return "String Editor";
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
    }

    public boolean supportsCustomEditor() {
        return !this.limitToTags;
    }

    public Component getCustomEditor() {
        return new StringCustomEditor((PropertyEditor)((Object)this), this.env);
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (this.rewriteDefaultTag && EMPTY_DEFAULT_STRING.equals(text)) {
            text = "";
        }
        super.setAsText(text);
    }

    public String[] getTags() {
        if (this.tags != null) {
            return this.tags.toArray(new String[this.tags.size()]);
        }
        return null;
    }
}

