/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.palette;

import java.beans.PropertyChangeListener;
import java.util.List;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.netbeans.spi.palette.PaletteFilter;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.praxislive.core.ComponentType;
import org.praxislive.ide.model.ContainerProxy;
import org.praxislive.ide.pxr.SubgraphDataObject;
import org.praxislive.ide.pxr.palette.DefaultPaletteActions;
import org.praxislive.ide.pxr.palette.PaletteFiles;
import org.praxislive.ide.pxr.palette.PaletteFilterNode;

public final class DefaultComponentPalette {
    private final PaletteController controller;
    private final Filter filter = new Filter();
    private final PropertyChangeListener listener;
    private ContainerProxy context;
    private List<ComponentType> types;

    private DefaultComponentPalette(DataFolder paletteFolder) {
        this.controller = PaletteFactory.createPalette((Node)new PaletteFilterNode(this, paletteFolder.getNodeDelegate()), (PaletteActions)new DefaultPaletteActions(), (PaletteFilter)this.filter, null);
        this.listener = e -> {
            if ("supported-types".equals(e.getPropertyName())) {
                this.revalidate();
            }
        };
        this.types = List.of();
    }

    public void context(ContainerProxy context) {
        if (this.context == context) {
            return;
        }
        if (this.context != null) {
            this.context.removePropertyChangeListener(this.listener);
        }
        if (context != null) {
            context.addPropertyChangeListener(this.listener);
        }
        this.context = context;
        this.revalidate();
    }

    public ContainerProxy context() {
        return this.context;
    }

    public PaletteController controller() {
        return this.controller;
    }

    public void dispose() {
        this.context(null);
    }

    public Node root() {
        return (Node)this.controller().getRoot().lookup(Node.class);
    }

    private void revalidate() {
        List newTypes = List.of();
        if (this.context != null) {
            newTypes = this.context.supportedTypes();
        }
        if (!this.types.equals(newTypes)) {
            this.types = newTypes;
            PaletteFiles.getDefault().addTypes(this.types);
            this.filter.types(this.types);
            this.controller.refresh();
        }
    }

    public static DefaultComponentPalette create(ContainerProxy container) {
        DataFolder paletteFolder = PaletteFiles.getDefault().paletteFolder();
        DefaultComponentPalette palette = new DefaultComponentPalette(paletteFolder);
        if (container != null) {
            palette.context(container);
        }
        return palette;
    }

    private static class Filter
    extends PaletteFilter {
        private List<ComponentType> types = List.of();

        private Filter() {
        }

        public boolean isValidCategory(Lookup lkp) {
            Node category = (Node)lkp.lookup(Node.class);
            for (Node item : category.getChildren().getNodes()) {
                if (!this.isValidItem(item.getLookup())) continue;
                return true;
            }
            return false;
        }

        public boolean isValidItem(Lookup lkp) {
            ComponentType type = (ComponentType)lkp.lookup(ComponentType.class);
            if (type != null) {
                return this.types.contains(type);
            }
            SubgraphDataObject.RequiredTypes reqTypes = (SubgraphDataObject.RequiredTypes)lkp.lookup(SubgraphDataObject.RequiredTypes.class);
            if (reqTypes != null) {
                if (reqTypes.requiredTypes().isEmpty()) {
                    return false;
                }
                return this.types.containsAll(reqTypes.requiredTypes());
            }
            return true;
        }

        private void types(List<ComponentType> types) {
            this.types = types;
        }
    }
}

