/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.palette;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.prefs.Preferences;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.RequestProcessor;
import org.praxislive.ide.core.api.IDE;

class Utils {
    static final RequestProcessor RP = new RequestProcessor("PXG");
    static final String KEY_PXG_LINK = "pxg-components-link";
    static final String KEY_PXG_LINK_INSTALLED = "pxg-components-link-installed";
    static final String PXG_FILE_NAME = "pxg.zip";
    static final String PXR_DOWNLOAD_FOLDER = "PXR/Downloads";
    static final String PXG_FILE_PATH = "PXR/Downloads/pxg.zip";
    static final String PALETTE_PATH = "PXR/Palette/";
    static final String CUSTOM_ROOTS_PATH = "Templates/Roots";
    private static final Map<String, String> knownFolders = Map.of("audio", "audio_custom", "core", "core_custom", "data", "data_custom", "tinkerforge", "tinkerforge_custom", "video", "video_custom", "videogl", "video_gl_custom");
    private static XMLFileSystem layer;
    private static Preferences info;

    private Utils() {
    }

    static boolean isInstalled() {
        return !info.get(KEY_PXG_LINK_INSTALLED, "").isEmpty() && FileUtil.getConfigFile((String)PXG_FILE_PATH) != null;
    }

    static boolean isLatest() {
        return Objects.equals(info.get(KEY_PXG_LINK, ""), info.get(KEY_PXG_LINK_INSTALLED, ""));
    }

    static boolean canInstall() {
        return !info.get(KEY_PXG_LINK, "").isEmpty();
    }

    static Map<String, String> knownFolders() {
        return knownFolders;
    }

    static void install() throws IOException {
        if (!Utils.isInstalled() || !Utils.isLatest()) {
            Utils.downloadZip();
        }
        try {
            Utils.installZip();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        info.put(KEY_PXG_LINK_INSTALLED, info.get(KEY_PXG_LINK, ""));
    }

    private static FileObject downloadZip() throws IOException {
        FileObject zip = FileUtil.getConfigFile((String)PXG_FILE_PATH);
        if (zip != null) {
            zip.delete();
        }
        FileObject folder = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)PXR_DOWNLOAD_FOLDER);
        zip = FileUtil.createData((FileObject)folder, (String)PXG_FILE_NAME);
        try (InputStream in = new URI(info.get(KEY_PXG_LINK, "")).toURL().openStream();
             OutputStream out = zip.getOutputStream();){
            FileUtil.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException | URISyntaxException ex) {
            IOException ioex;
            info.remove(KEY_PXG_LINK_INSTALLED);
            zip.delete();
            throw ex instanceof IOException ? (ioex = (IOException)ex) : new IOException(ex);
        }
        return zip;
    }

    private static void installZip() throws Exception {
        FileObject zip = FileUtil.getConfigFile((String)PXG_FILE_PATH);
        FileObject root = FileUtil.getArchiveRoot((FileObject)zip);
        FileObject[] children = root.getChildren();
        if (children.length == 1 && children[0].isFolder()) {
            root = children[0];
            children = root.getChildren();
        }
        block8: for (FileObject folder : children) {
            String sourceName;
            if (!folder.isFolder()) continue;
            switch (sourceName = folder.getNameExt().toLowerCase(Locale.ROOT)) {
                case "roots": {
                    Utils.installRoots(folder);
                    continue block8;
                }
                case "components": {
                    Utils.installComponents(folder);
                    continue block8;
                }
                default: {
                    String targetFolder = knownFolders.get(sourceName);
                    if (targetFolder == null) continue block8;
                    Utils.installLegacyComponents(folder, targetFolder);
                }
            }
        }
    }

    private static void installRoots(FileObject source) throws Exception {
        FileObject dest = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)CUSTOM_ROOTS_PATH);
        for (FileObject file : source.getChildren()) {
            if (!file.hasExt("pxr") && !file.hasExt("pxx")) continue;
            FileObject existing = dest.getFileObject(file.getNameExt());
            if (existing != null) {
                existing.delete();
            }
            FileObject template = FileUtil.copyFile((FileObject)file, (FileObject)dest, (String)file.getName());
            template.setAttribute("template", (Object)true);
            template.setAttribute("displayName", (Object)file.getName());
        }
    }

    private static void installComponents(FileObject source) throws Exception {
        FileObject palette = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)PALETTE_PATH);
        for (FileObject category : source.getChildren()) {
            FileObject dest = FileUtil.createFolder((FileObject)palette, (String)category.getNameExt());
            for (FileObject file : category.getChildren()) {
                if (!file.hasExt("pxg")) continue;
                FileObject existing = dest.getFileObject(file.getNameExt());
                if (existing != null) {
                    existing.delete();
                }
                FileUtil.copyFile((FileObject)file, (FileObject)dest, (String)file.getName());
            }
        }
    }

    private static void installLegacyComponents(FileObject source, String target) throws Exception {
        FileObject dest = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)("PXR/Palette//" + target));
        for (FileObject file : source.getChildren()) {
            if (!file.hasExt("pxg")) continue;
            FileObject existing = dest.getFileObject(file.getNameExt());
            if (existing != null) {
                existing.delete();
            }
            FileUtil.copyFile((FileObject)file, (FileObject)dest, (String)file.getName());
        }
    }

    static {
        info = IDE.getPreferences();
    }
}

