/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.actions.Savable;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Value;
import org.praxislive.core.types.PMap;
import org.praxislive.ide.code.api.DynamicPaths;
import org.praxislive.ide.code.api.SharedCodeInfo;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.pxr.BoundArgumentProperty;

class BoundSharedCodeProperty
extends BoundArgumentProperty {
    private final PraxisProject project;
    private final FileSystem fileSystem;
    private final FileObject sharedFolder;
    private final Listener fileListener;
    private DynamicPaths.SharedKey sharedKey;
    private boolean valueIsAdjusting;

    BoundSharedCodeProperty(PraxisProject project, ControlAddress address, ControlInfo info) {
        super(project, address, info);
        this.project = project;
        this.fileSystem = FileUtil.createMemoryFileSystem();
        this.fileListener = new Listener();
        try {
            this.sharedFolder = this.fileSystem.getRoot().createFolder("SHARED");
            this.sharedFolder.addRecursiveListener((FileChangeListener)this.fileListener);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        this.sharedKey = DynamicPaths.getDefault().registerShared(project, this.fileSystem.getRoot(), this.sharedFolder);
        this.setHidden(true);
        this.addPropertyChangeListener(this::updateFiles);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.sharedKey.unregister();
        this.sharedKey = null;
        this.sharedFolder.removeRecursiveListener((FileChangeListener)this.fileListener);
        try {
            this.sharedFolder.getChildren(true).asIterator().forEachRemaining(file -> {
                if (file.isData()) {
                    this.removeFile((FileObject)file);
                }
            });
            this.sharedFolder.delete();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    SharedCodeInfo getSharedCodeInfo() {
        return this.sharedKey.info();
    }

    void openFile(String binaryName) {
        FileObject file = this.fileSystem.findResource(this.toFileName(binaryName));
        if (file != null) {
            try {
                Openable openable = (Openable)DataObject.find((FileObject)file).getLookup().lookup(Openable.class);
                if (openable != null) {
                    openable.open();
                }
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFiles(PropertyChangeEvent update) {
        if (this.valueIsAdjusting || this.sharedKey == null) {
            return;
        }
        try {
            this.valueIsAdjusting = true;
            PMap oldFiles = PMap.from((Value)((Value)update.getOldValue())).orElse(PMap.EMPTY);
            PMap newFiles = PMap.from((Value)((Value)update.getNewValue())).orElse(PMap.EMPTY);
            ArrayList workingList = new ArrayList();
            workingList.addAll(oldFiles.keys());
            workingList.removeAll(newFiles.keys());
            workingList.forEach(this::removeFile);
            workingList.clear();
            workingList.addAll(newFiles.keys());
            workingList.removeAll(oldFiles.keys());
            workingList.forEach(f -> this.addFile((String)f, newFiles.getString(f, "")));
        }
        finally {
            this.valueIsAdjusting = false;
        }
    }

    private void addFile(String binaryName, String source) {
        try {
            FileObject file = FileUtil.createData((FileObject)this.fileSystem.getRoot(), (String)this.toFileName(binaryName));
            file.setAttribute("project", (Object)this.project);
            file.setAttribute("controlAddress", (Object)this.getAddress());
            try (OutputStreamWriter writer = new OutputStreamWriter(file.getOutputStream());){
                writer.append(source);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void removeFile(String binaryName) {
        FileObject file = this.fileSystem.findResource(this.toFileName(binaryName));
        if (file != null) {
            this.removeFile(file);
        }
    }

    private void removeFile(FileObject file) {
        try {
            EditorCookie editor;
            DataObject dob = DataObject.find((FileObject)file);
            Savable savable = (Savable)dob.getLookup().lookup(Savable.class);
            if (savable != null) {
                savable.save();
            }
            if ((editor = (EditorCookie)dob.getLookup().lookup(EditorCookie.class)) != null) {
                editor.close();
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private String toFileName(String binaryName) {
        return binaryName.replace('.', '/') + ".java";
    }

    private String toBinaryName(String path) {
        int i = path.lastIndexOf(46);
        if (i > 0) {
            return path.substring(0, i).replace('/', '.');
        }
        return path.replace('/', '.');
    }

    private class Listener
    implements FileChangeListener {
        private Listener() {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
            this.update();
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            if (fe.getFile() == BoundSharedCodeProperty.this.sharedFolder) {
                throw new IllegalStateException("Shared folder deleted!");
            }
            this.update();
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.update();
        }

        private void update() {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(this::update);
            }
            if (BoundSharedCodeProperty.this.valueIsAdjusting || BoundSharedCodeProperty.this.sharedKey == null) {
                return;
            }
            BoundSharedCodeProperty.this.valueIsAdjusting = true;
            try {
                PMap.Builder mapBuilder = PMap.builder();
                BoundSharedCodeProperty.this.sharedFolder.getChildren(true).asIterator().forEachRemaining(file -> {
                    if ("java".equals(file.getExt())) {
                        try {
                            mapBuilder.put(BoundSharedCodeProperty.this.toBinaryName(file.getPath()), file.asText());
                        }
                        catch (IOException ex) {
                            throw new IllegalStateException(ex);
                        }
                    }
                });
                BoundSharedCodeProperty.this.setValue((Value)mapBuilder.build());
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                BoundSharedCodeProperty.this.valueIsAdjusting = false;
            }
        }
    }
}

