/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.Action;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.windows.Mode;
import org.openide.windows.ModeSelector;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.praxislive.ide.core.api.IDE;
import org.praxislive.ide.pxr.RootEditorTopComponent;

public final class EditorModes {
    private static final String KEY_CONFIGURATION = "pxr-editor-tab-grouping";
    private static final String SPLIT_ON_OPEN = "split-on-open";
    private static final EditorModes INSTANCE = new EditorModes();
    private static final int DEFAULT_SPLIT_WIDTH = 1600;
    private Configuration activeConfiguration;

    private EditorModes() {
        TopComponent.getRegistry().addPropertyChangeListener(this::registryPropertyChange);
        this.activeConfiguration = Configuration.Default;
        String config = IDE.getPreferences().get(KEY_CONFIGURATION, null);
        if (config != null) {
            try {
                this.activeConfiguration = Configuration.valueOf(config);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public Configuration getActiveConfiguration() {
        return this.activeConfiguration;
    }

    public void setActiveConfiguration(Configuration configuration) {
        this.activeConfiguration = Objects.requireNonNull(configuration);
        if (configuration == Configuration.Default) {
            IDE.getPreferences().remove(KEY_CONFIGURATION);
        } else {
            IDE.getPreferences().put(KEY_CONFIGURATION, configuration.name());
        }
    }

    private Mode selectModeImpl(TopComponent tc, Mode mode) {
        if (!WindowManager.getDefault().isEditorMode(mode) || !this.isFileEditor(tc)) {
            return mode;
        }
        boolean rootEditor = this.isRootEditor(tc);
        if (rootEditor && !this.containsNoneRootEditors(mode)) {
            return mode;
        }
        if (!rootEditor && !this.containsOnlyRootEditors(mode)) {
            return mode;
        }
        List<Mode> editorModes = this.findEditorModes();
        if (!editorModes.contains(mode)) {
            return mode;
        }
        if (editorModes.size() == 1) {
            TopComponent active = mode.getSelectedTopComponent();
            tc.putClientProperty((Object)SPLIT_ON_OPEN, (Object)active);
            return mode;
        }
        if (rootEditor) {
            return editorModes.stream().filter(this::containsOnlyRootEditors).findFirst().orElse(mode);
        }
        return editorModes.stream().filter(Predicate.not(this::containsOnlyRootEditors)).findFirst().orElse(mode);
    }

    private boolean isFileEditor(TopComponent tc) {
        return tc.getLookup().lookup(DataObject.class) != null;
    }

    private List<Mode> findEditorModes() {
        return WindowManager.getDefault().getModes().stream().filter(arg_0 -> ((WindowManager)WindowManager.getDefault()).isEditorMode(arg_0)).map(Mode.class::cast).toList();
    }

    private boolean isRootEditor(TopComponent tc) {
        return tc instanceof RootEditorTopComponent;
    }

    private boolean containsNoneRootEditors(Mode mode) {
        return Stream.of(WindowManager.getDefault().getOpenedTopComponents(mode)).filter(this::isFileEditor).anyMatch(Predicate.not(this::isRootEditor));
    }

    private boolean containsOnlyRootEditors(Mode mode) {
        return Stream.of(WindowManager.getDefault().getOpenedTopComponents(mode)).filter(this::isFileEditor).allMatch(this::isRootEditor);
    }

    private void registryPropertyChange(PropertyChangeEvent evt) {
        TopComponent activated;
        Action[] actionArray;
        if ("activated".equals(evt.getPropertyName()) && (actionArray = (activated = TopComponent.getRegistry().getActivated()).getClientProperty((Object)SPLIT_ON_OPEN)) instanceof TopComponent) {
            TopComponent previous = (TopComponent)actionArray;
            activated.putClientProperty((Object)SPLIT_ON_OPEN, null);
            if (this.findEditorModes().size() > 1) {
                return;
            }
            if (this.activeConfiguration == Configuration.Never) {
                return;
            }
            if (this.activeConfiguration == Configuration.Default) {
                Frame main = WindowManager.getDefault().getMainWindow();
                if (main.getSize().width < 1600) {
                    return;
                }
            }
            for (Action a : activated.getActions()) {
                if (a == null || !"NewTabGroupAction".equals(a.getClass().getSimpleName())) continue;
                a.actionPerformed(new ActionEvent(this, 1001, ""));
                previous.requestVisible();
                break;
            }
        }
    }

    public static EditorModes getDefault() {
        return INSTANCE;
    }

    public static enum Configuration {
        Default,
        Always,
        Never;

    }

    public static final class Selector
    implements ModeSelector {
        public Mode selectModeForOpen(TopComponent tc, Mode mode) {
            return EditorModes.getDefault().selectModeImpl(tc, mode);
        }
    }
}

