/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.nodes.Node;
import org.praxislive.base.Binding;
import org.praxislive.ide.core.api.Syncable;
import org.praxislive.ide.pxr.PXRComponentProxy;

class PXRComponentEditor {
    private static final Logger LOG = Logger.getLogger(PXRComponentEditor.class.getName());
    private PXRComponentProxy component;
    private Dialog dialog;
    private JComponent editor;
    private Listener listener;
    private Map<String, PropertyPanel> propPanels;
    private List<Binding.Adaptor> adaptors;

    PXRComponentEditor(PXRComponentProxy component) {
        this.component = component;
    }

    void show() {
        if (this.dialog != null) {
            this.dialog.setVisible(true);
            this.dialog.toFront();
            return;
        }
        this.initEditor();
        if (this.listener == null) {
            this.listener = new Listener();
        }
        DialogDescriptor descriptor = new DialogDescriptor((Object)this.editor, this.component.getAddress().toString(), false, new Object[]{"Close"}, null, 0, null, null, false);
        this.dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        this.dialog.addWindowListener(this.listener);
        Syncable sync = (Syncable)this.component.getLookup().lookup(Syncable.class);
        assert (sync != null);
        if (sync != null) {
            sync.addKey((Object)this);
        }
        this.dialog.setVisible(true);
    }

    void dispose() {
        this.dispose(true);
    }

    private void dispose(boolean closeDialog) {
        if (this.dialog != null) {
            Syncable sync = (Syncable)this.component.getLookup().lookup(Syncable.class);
            assert (sync != null);
            if (sync != null) {
                sync.removeKey((Object)this);
            }
            if (closeDialog) {
                this.dialog.setVisible(false);
            }
            this.dialog = null;
        }
    }

    private void initEditor() {
        PropertySheet propertyPanel = new PropertySheet();
        propertyPanel.setNodes(new Node[]{this.component.getNodeDelegate()});
        propertyPanel.setDescriptionAreaVisible(false);
        propertyPanel.setPreferredSize(new Dimension(350, this.calculateHeight()));
        this.editor = new JPanel(new BorderLayout());
        this.editor.add((Component)new JScrollPane((Component)propertyPanel), "Center");
    }

    private int calculateHeight() {
        int rowHeight = UIManager.getInt("netbeans.ps.rowheight");
        if (rowHeight < 16) {
            rowHeight = 16;
        }
        ++rowHeight;
        int count = 0;
        Node node = this.component.getNodeDelegate();
        for (Node.PropertySet propSet : node.getPropertySets()) {
            ++count;
            for (Node.Property prop : propSet.getProperties()) {
                if (prop.isHidden()) continue;
                ++count;
            }
        }
        count = Math.max(count, 4);
        return Math.min(count * rowHeight, 500);
    }

    private class Listener
    extends WindowAdapter {
        private Listener() {
        }

        @Override
        public void windowClosed(WindowEvent we) {
            PXRComponentEditor.this.dialog.removeWindowListener(this);
            PXRComponentEditor.this.dispose(false);
        }
    }
}

