/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.praxislive.ide.model.RootProxy;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.project.spi.RootRegistry;
import org.praxislive.ide.pxr.PXRRootProxy;

public class PXRRootRegistry
implements RootRegistry {
    private final PraxisProject project;
    private final Set<PXRRootProxy> roots;
    private final PropertyChangeSupport pcs;

    public PXRRootRegistry(Lookup lookup) {
        this.project = Objects.requireNonNull((PraxisProject)lookup.lookup(PraxisProject.class));
        this.roots = new LinkedHashSet<PXRRootProxy>();
        this.pcs = new PropertyChangeSupport(this);
    }

    public Optional<RootProxy> find(String id) {
        return this.roots.stream().filter(r -> r.getAddress().rootID().equals(id)).map(RootProxy.class::cast).findFirst();
    }

    public List<RootProxy> findAll() {
        return this.roots.stream().collect(Collectors.toList());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    void register(PXRRootProxy root) {
        if (root == null) {
            throw new NullPointerException();
        }
        if (this.roots.contains(root)) {
            throw new IllegalArgumentException();
        }
        this.roots.add(root);
        this.fireRootsChange();
    }

    void remove(PXRRootProxy root) {
        this.roots.remove(root);
        this.fireRootsChange();
    }

    private void fireRootsChange() {
        this.pcs.firePropertyChange("roots", null, null);
    }

    PXRRootProxy[] getRoots() {
        return this.roots.toArray(new PXRRootProxy[this.roots.size()]);
    }

    PXRRootProxy getRootByID(String id) {
        return this.roots.stream().filter(r -> r.getAddress().rootID().equals(id)).findFirst().orElse(null);
    }

    PXRRootProxy getRootByFile(FileObject file) {
        return this.roots.stream().filter(r -> r.getSourceFile().equals(file)).findFirst().orElse(null);
    }

    static PXRRootProxy findRootForFile(FileObject file) {
        PXRRootRegistry reg = PXRRootRegistry.registryForFile(file);
        if (reg != null) {
            return reg.getRootByFile(file);
        }
        return null;
    }

    static PXRRootRegistry registryForFile(FileObject file) {
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project == null) {
            return null;
        }
        return (PXRRootRegistry)project.getLookup().lookup(PXRRootRegistry.class);
    }
}

