/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.praxislive.ide.pxr.Bundle;
import org.praxislive.ide.pxr.PXRDataObject;
import org.praxislive.ide.pxr.PXRWizardPanel1;

final class PXRVisualPanel1
extends JPanel
implements DocumentListener {
    private final PXRWizardPanel1 wizardPanel;
    private JTextField fileField;
    private JLabel fileLabel;
    private JTextField idField;
    private JLabel idLabel;

    PXRVisualPanel1(PXRWizardPanel1 wizardPanel) {
        this.wizardPanel = wizardPanel;
        this.initComponents();
        this.idField.getDocument().addDocumentListener(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        FileObject file = this.wizardPanel.getTemplateFile();
        try {
            DataObject dob = DataObject.find((FileObject)file);
            this.idField.setText(PXRDataObject.findRootID(dob));
        }
        catch (Exception ex) {
            this.idField.setText(file.getName());
        }
    }

    @Override
    public String getName() {
        return Bundle.LBL_PXRWizardPanel();
    }

    private void initComponents() {
        this.idField = new JTextField();
        this.idLabel = new JLabel();
        this.fileField = new JTextField();
        this.fileLabel = new JLabel();
        this.idField.setText(NbBundle.getMessage(PXRVisualPanel1.class, (String)"PXRVisualPanel1.idField.text_1"));
        Mnemonics.setLocalizedText((JLabel)this.idLabel, (String)NbBundle.getMessage(PXRVisualPanel1.class, (String)"PXRVisualPanel1.idLabel.text_1"));
        this.fileField.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(PXRVisualPanel1.class, (String)"PXRVisualPanel1.fileLabel.text_1"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(40, 40, 40).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.idLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.idField, -1, 379, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(26, 26, 26).addComponent(this.fileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileField, -1, 379, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.idField, -2, -1, -2).addComponent(this.idLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileField, -2, -1, -2).addComponent(this.fileLabel)).addContainerGap(209, Short.MAX_VALUE)));
    }

    String getRootID() {
        return this.idField.getText();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.update();
    }

    private void update() {
        this.fileField.setText(this.wizardPanel.getProjectDir().getPath() + "/" + this.idField.getText() + ".pxr");
        this.wizardPanel.validate();
    }
}

