/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.EventQueue;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.praxislive.ide.core.api.Callback;
import org.praxislive.ide.project.api.ExecutionLevel;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.project.api.ProjectProperties;
import org.praxislive.ide.pxr.Bundle;
import org.praxislive.ide.pxr.PXRDataObject;
import org.praxislive.ide.pxr.PXRFileHandler;
import org.praxislive.ide.pxr.PXRHelper;
import org.praxislive.ide.pxr.PXRWizardPanel1;
import org.praxislive.project.GraphModel;
import org.praxislive.project.ParseException;

final class PXRWizardIterator
implements TemplateWizard.Iterator {
    static final Logger LOG = Logger.getLogger(PXRWizardIterator.class.getName());
    public static final String PROP_PXR_ID = "PXR.id";
    public static final String PROP_PXR_FILE = "PXR.file";
    public static final String PROP_PXR_TYPE = "PXR.type";
    private int index;
    private WizardDescriptor.Panel[] panels;

    PXRWizardIterator() {
    }

    public void initialize(TemplateWizard wizard) {
        FileObject projectDir = Templates.getProject((WizardDescriptor)wizard).getProjectDirectory();
        FileObject templateFile = Templates.getTemplate((WizardDescriptor)wizard);
        this.panels = new WizardDescriptor.Panel[]{new PXRWizardPanel1(projectDir, templateFile)};
    }

    public Set<DataObject> instantiate(TemplateWizard wizard) throws IOException {
        try {
            String id = wizard.getProperty(PROP_PXR_ID).toString();
            Project project = Templates.getProject((WizardDescriptor)wizard);
            FileObject projectDir = project.getProjectDirectory();
            FileObject templateFile = Templates.getTemplate((WizardDescriptor)wizard);
            FileObject file = this.createFile(projectDir, templateFile, id);
            boolean build = true;
            boolean autostart = true;
            Runnable task = () -> {
                ProjectProperties props = (ProjectProperties)project.getLookup().lookup(ProjectProperties.class);
                if (props != null) {
                    try {
                        props.addFile(ExecutionLevel.BUILD, file);
                        if (autostart) {
                            props.addLine(ExecutionLevel.RUN, "/" + id + ".start");
                        }
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if (build) {
                    this.buildFile(project, file);
                }
            };
            if (EventQueue.isDispatchThread()) {
                task.run();
            } else {
                try {
                    EventQueue.invokeAndWait(task);
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return Collections.singleton(DataObject.find((FileObject)file));
        }
        catch (ParseException ex) {
            throw new IOException(ex);
        }
    }

    public void uninitialize(TemplateWizard wizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.panels.length;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private FileObject createFile(FileObject projectDir, FileObject templateFile, String id) throws IOException, ParseException {
        String script = templateFile.asText();
        GraphModel model = GraphModel.parse((String)script);
        model = model.withRename(id);
        script = model.writeToString();
        Path file = FileUtil.toPath((FileObject)projectDir).resolve(id + ".pxr");
        Files.writeString(file, (CharSequence)script, StandardOpenOption.CREATE_NEW);
        return FileUtil.toFileObject((Path)file);
    }

    private void buildFile(Project base, FileObject file) {
        try {
            PraxisProject project = (PraxisProject)base.getLookup().lookup(PraxisProject.class);
            PXRHelper helper = (PXRHelper)((Object)project.getLookup().lookup(PXRHelper.class));
            if (helper != null && helper.isConnected()) {
                DataObject dob = DataObject.find((FileObject)file);
                if (dob instanceof PXRDataObject) {
                    new PXRFileHandler(project, (PXRDataObject)dob).process(Callback.create(r -> {}));
                }
            } else {
                String name = ProjectUtils.getInformation((Project)project).getDisplayName();
                Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.MSG_buildProject(name), Bundle.TITLE_buildProject(), 0));
                if (ret == NotifyDescriptor.YES_OPTION) {
                    ActionProvider actions = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
                    actions.invokeAction("build", Lookup.EMPTY);
                }
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static class PrivilegedTemplatesImpl
    implements PrivilegedTemplates {
        public String[] getPrivilegedTemplates() {
            return new String[]{"Templates/Roots/audio.pxr", "Templates/Roots/video.pxr", "Templates/Roots/gui.pxr", "Templates/Roots/data.pxr", "Templates/Roots/root.pxr"};
        }
    }
}

