/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.openide.awt.Actions;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PMap;
import org.praxislive.ide.code.api.SharedCodeInfo;
import org.praxislive.ide.model.Proxy;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.pxr.ActionEditorContext;
import org.praxislive.ide.pxr.PXRComponentProxy;
import org.praxislive.ide.pxr.PXRContainerProxy;
import org.praxislive.ide.pxr.PXRDataObject;
import org.praxislive.ide.pxr.PXRRootProxy;
import org.praxislive.ide.pxr.PXRRootRegistry;
import org.praxislive.ide.pxr.RootConfigAction;
import org.praxislive.ide.pxr.SharedCodePanel;
import org.praxislive.ide.pxr.StartableRootAction;
import org.praxislive.ide.pxr.TableRootEditor;
import org.praxislive.ide.pxr.ToolActions;
import org.praxislive.ide.pxr.palette.DefaultComponentPalette;
import org.praxislive.ide.pxr.spi.RootEditor;

public class RootEditorTopComponent
extends CloneableTopComponent {
    private static final Action START_STOP_ACTION = Actions.forID((String)"PXR", (String)StartableRootAction.class.getName());
    private static final Action ROOT_CONFIG_ACTION = Actions.forID((String)"PXR", (String)RootConfigAction.class.getName());
    private final PXRDataObject dob;
    private final EditorLookup lookup;
    private final PropertyChangeListener registryListener;
    private final PropertyChangeListener infoListener;
    private final JToolBar toolBar;
    private final ExplorerManager explorerManager;
    private final EditorHolder editorHolder;
    private JComponent editorComponent;
    private RootEditor editor;
    private PXRRootProxy root;
    private PMap editorHint;
    private ActionEditorContext actionContext;
    private DefaultComponentPalette palette;

    public RootEditorTopComponent(PXRDataObject dob) {
        this.setDisplayName(dob.getName());
        this.setIcon(dob.getNodeDelegate().getIcon(1));
        this.dob = dob;
        this.explorerManager = new ExplorerManager();
        this.explorerManager.addPropertyChangeListener(evt -> {
            if (this.root == null || this.actionContext == null || this.palette == null) {
                return;
            }
            PXRContainerProxy context = Optional.ofNullable(this.explorerManager.getExploredContext()).map(n -> (PXRContainerProxy)n.getLookup().lookup(PXRContainerProxy.class)).orElse(this.root);
            List<PXRComponentProxy> selection = Stream.of(this.explorerManager.getSelectedNodes()).map(n -> (PXRComponentProxy)n.getLookup().lookup(PXRComponentProxy.class)).filter(c -> c != null).toList();
            this.palette.context(context);
            this.actionContext.updateSelection(context, selection);
        });
        this.lookup = new EditorLookup(Lookups.singleton((Object)((Object)dob)), ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)this.getActionMap()), dob.getLookup());
        this.associateLookup((Lookup)this.lookup);
        this.setLayout(new BorderLayout());
        this.toolBar = new ToolBar();
        this.add(this.toolBar, "North");
        this.registryListener = evt -> this.checkRoot();
        this.infoListener = evt -> {
            if ("info".equals(evt.getPropertyName())) {
                this.checkEditorHint();
            }
        };
        this.editorHint = PMap.EMPTY;
        this.editorHolder = new EditorHolder(this.explorerManager);
        this.add(this.editorHolder);
    }

    public void requestFocus() {
        if (this.editor != null) {
            this.editor.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        if (this.editor != null) {
            return this.editor.requestFocus();
        }
        return super.requestFocusInWindow();
    }

    protected void componentOpened() {
        assert (EventQueue.isDispatchThread());
        this.root = null;
        this.editorHint = PMap.EMPTY;
        PXRRootRegistry registry = PXRRootRegistry.registryForFile(this.dob.getPrimaryFile());
        if (registry != null) {
            this.root = registry.getRootByFile(this.dob.getPrimaryFile());
            registry.addPropertyChangeListener(this.registryListener);
            if (this.root != null) {
                this.root.addPropertyChangeListener(this.infoListener);
                this.editorHint = this.findEditorHint();
            }
        }
        this.install(this.root);
    }

    protected void componentShowing() {
        if (this.editor != null) {
            this.editor.componentShowing();
        }
    }

    protected void componentActivated() {
        if (this.editor != null) {
            this.editor.componentActivated();
        }
    }

    protected void componentDeactivated() {
        if (this.editor != null) {
            this.editor.componentDeactivated();
        }
    }

    protected void componentHidden() {
        if (this.editor != null) {
            this.editor.componentHidden();
        }
    }

    protected void componentClosed() {
        this.syncEditor();
        PXRRootRegistry registry = PXRRootRegistry.registryForFile(this.dob.getPrimaryFile());
        if (registry != null) {
            registry.removePropertyChangeListener(this.registryListener);
        }
        if (this.root != null) {
            this.root.removePropertyChangeListener(this.infoListener);
        }
        this.uninstall(this.root);
    }

    protected CloneableTopComponent createClonedObject() {
        return new RootEditorTopComponent(this.dob);
    }

    void syncEditor() {
        if (this.editor != null) {
            this.editor.sync();
        }
    }

    private void checkRoot() {
        PXRRootProxy root = PXRRootRegistry.findRootForFile(this.dob.getPrimaryFile());
        if (root == this.root) {
            return;
        }
        if (root == null) {
            if (this.root != null) {
                this.root.removePropertyChangeListener(this.infoListener);
                this.root = null;
            }
            this.close();
        } else {
            if (this.root != null) {
                this.root.removePropertyChangeListener(this.infoListener);
            }
            this.uninstall(this.root);
            this.root = root;
            this.editorHint = this.findEditorHint();
            root.addPropertyChangeListener(this.infoListener);
            this.install(root);
        }
    }

    private void checkEditorHint() {
        PMap hint = this.findEditorHint();
        if (!Objects.equals(this.editorHint, hint)) {
            this.editorHint = hint;
            this.uninstall(this.root);
            this.install(this.root);
        }
    }

    private PMap findEditorHint() {
        return Optional.ofNullable(this.root).map(r -> r.getInfo().properties().get("display-hint")).flatMap(PMap::from).orElse(PMap.EMPTY);
    }

    private void actionContextSelect(PXRContainerProxy container, List<PXRComponentProxy> children) {
        try {
            Node context = container.getNodeDelegate();
            Node[] selection = (Node[])children.stream().map(Proxy::getNodeDelegate).toArray(Node[]::new);
            this.explorerManager.setExploredContextAndSelection(context, selection);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void install(PXRRootProxy root) {
        SharedCodePanel sharedCodePanel = null;
        ToolActions toolActions = null;
        if (root == null) {
            this.explorerManager.setRootContext(Node.EMPTY);
            this.editor = new BlankEditor(this.dob);
            this.lookup.setAdditional(this.editor.getLookup());
            this.initToolbar(List.of());
        } else {
            this.explorerManager.setRootContext(root.getNodeDelegate());
            sharedCodePanel = this.findSharedCode(root);
            EditorContext context = new EditorContext(this, root, sharedCodePanel == null ? null : sharedCodePanel.getToggleAction());
            this.editor = this.findEditor(context, root);
            this.palette = DefaultComponentPalette.create(root);
            this.actionContext = new ActionEditorContext(this.editor, root, this.palette.root(), this::actionContextSelect);
            toolActions = new ToolActions(this.actionContext, this.editor.supportedToolActions());
            this.lookup.setAdditional(Lookups.fixed((Object[])new Object[]{this.actionContext, this.palette.controller()}), Lookups.exclude((Lookup)this.editor.getLookup(), (Class[])new Class[]{ActionMap.class}));
            this.initToolbar(this.buildActions(this.editor));
        }
        this.editorComponent = this.editor.getEditorComponent();
        this.editorHolder.install(this.editorComponent, sharedCodePanel, toolActions);
        if (this.isVisible()) {
            this.editor.componentShowing();
            this.editor.componentActivated();
        }
    }

    private SharedCodePanel findSharedCode(PXRRootProxy root) {
        SharedCodeInfo sharedInfo = (SharedCodeInfo)root.getLookup().lookup(SharedCodeInfo.class);
        if (sharedInfo == null) {
            return null;
        }
        return new SharedCodePanel(sharedInfo.getFolder());
    }

    private RootEditor findEditor(EditorContext context, PXRRootProxy root) {
        String editorType = this.editorHint.getString("type", "");
        if ("table".equals(editorType)) {
            List<String> props = Optional.ofNullable(this.editorHint.get("properties")).flatMap(PArray::from).map(a -> a.asListOf(String.class)).orElse(List.of());
            return new TableRootEditor(root, context, props);
        }
        return Lookup.getDefault().lookupAll(RootEditor.Provider.class).stream().flatMap(p -> p.createEditor(root, context).stream()).findFirst().orElseGet(() -> new TableRootEditor(root, context, List.of()));
    }

    private List<Action> buildActions(RootEditor editor) {
        List<Action> editorActions = editor.getActions();
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(START_STOP_ACTION);
        actions.add(ROOT_CONFIG_ACTION);
        if (!editorActions.isEmpty()) {
            actions.add(null);
            actions.addAll(editorActions);
        }
        return actions;
    }

    private void uninstall(PXRRootProxy root) {
        this.editorHolder.uninstall();
        this.editorComponent = null;
        this.editor.dispose();
        this.editor = null;
        this.lookup.removeAdditional();
        if (this.palette != null) {
            this.palette.dispose();
            this.palette = null;
        }
        this.explorerManager.setRootContext(Node.EMPTY);
        this.actionContext = null;
    }

    private void initToolbar(List<Action> actions) {
        this.toolBar.removeAll();
        Lookup context = this.getLookup();
        for (Action action : actions) {
            Component c;
            if (action instanceof ContextAwareAction) {
                action = ((ContextAwareAction)action).createContextAwareInstance(context);
            }
            if (action instanceof Presenter.Toolbar) {
                c = ((Presenter.Toolbar)action).getToolbarPresenter();
            } else if (action == null) {
                c = new JToolBar.Separator();
            } else {
                JButton button = new JButton();
                Actions.connect((AbstractButton)button, (Action)action);
                c = button;
            }
            if (c instanceof AbstractButton) {
                c.setFocusable(false);
            }
            this.toolBar.add(c);
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    private static final class EditorLookup
    extends ProxyLookup {
        private final List<Lookup> permanent;

        private EditorLookup(Lookup ... lookups) {
            super(lookups);
            this.permanent = List.of(lookups);
        }

        private void setAdditional(Lookup ... lookups) {
            if (lookups.length == 0) {
                this.setLookups((Lookup[])this.permanent.toArray(Lookup[]::new));
            } else {
                this.setLookups((Lookup[])Stream.concat(this.permanent.stream(), Stream.of(lookups)).toArray(Lookup[]::new));
            }
        }

        private void removeAdditional() {
            this.setAdditional(new Lookup[0]);
        }
    }

    private static final class ToolBar
    extends JToolBar {
        ToolBar() {
            super("editorToolbar");
            this.setFocusable(false);
            this.setFloatable(false);
            this.setRollover(true);
            this.setBorder(BorderFactory.createEtchedBorder());
        }
    }

    private static class EditorHolder
    extends JPanel
    implements ExplorerManager.Provider {
        private final ExplorerManager em;

        private EditorHolder(ExplorerManager em) {
            this.em = em;
            this.setLayout(new BorderLayout());
        }

        public ExplorerManager getExplorerManager() {
            return this.em;
        }

        private void install(JComponent editorComponent, SharedCodePanel sharedCodePanel, ToolActions toolActions) {
            this.removeAll();
            this.add((Component)editorComponent, "Center");
            if (sharedCodePanel != null) {
                this.add((Component)sharedCodePanel, "West");
            }
            if (toolActions != null) {
                toolActions.installActions(this.getInputMap(1), this.getActionMap());
                this.add((Component)toolActions.getActionPanel(), "South");
            }
        }

        private void uninstall() {
            this.removeAll();
            this.resetKeyboardActions();
        }
    }

    private static class BlankEditor
    implements RootEditor {
        private final PXRDataObject dob;

        private BlankEditor(PXRDataObject dob) {
            this.dob = dob;
        }

        @Override
        public Lookup getLookup() {
            return Lookups.singleton((Object)this.dob.getNodeDelegate());
        }

        @Override
        public JComponent getEditorComponent() {
            JLabel editor = new JLabel("<Build " + this.dob.getName() + " to edit>", 0);
            editor.setFocusable(true);
            return editor;
        }
    }

    private static final class EditorContext
    implements RootEditor.Context {
        private final RootEditorTopComponent container;
        private final FileObject file;
        private final PraxisProject project;
        private final Action showSharedCodeAction;

        EditorContext(RootEditorTopComponent container, PXRRootProxy root, Action showSharedCodeAction) {
            this.container = container;
            this.file = root.getSource().getPrimaryFile();
            this.project = root.getProject();
            this.showSharedCodeAction = showSharedCodeAction;
        }

        @Override
        public TopComponent container() {
            return this.container;
        }

        @Override
        public ExplorerManager explorerManager() {
            return this.container.explorerManager;
        }

        @Override
        public Optional<FileObject> file() {
            return Optional.of(this.file);
        }

        @Override
        public Optional<PraxisProject> project() {
            return Optional.of(this.project);
        }

        @Override
        public Optional<Action> sharedCodeAction() {
            return Optional.ofNullable(this.showSharedCodeAction);
        }
    }
}

