/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.praxislive.core.Value;
import org.praxislive.core.types.PArray;
import org.praxislive.ide.core.api.Task;
import org.praxislive.ide.project.api.ProjectProperties;
import org.praxislive.ide.pxr.PXRDataObject;
import org.praxislive.ide.pxr.PXRRootProxy;
import org.praxislive.ide.pxr.PXRRootRegistry;
import org.praxislive.ide.pxr.SaveAsTemplateWizard;
import org.praxislive.ide.pxr.SaveTask;
import org.praxislive.project.SyntaxUtils;

public final class SaveAsTemplateAction
implements ActionListener {
    private static final RequestProcessor RP = new RequestProcessor();
    private final PXRDataObject rootDOB;

    public SaveAsTemplateAction(PXRDataObject context) {
        this.rootDOB = context;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Project project = FileOwnerQuery.getOwner((FileObject)this.rootDOB.getPrimaryFile());
        ProjectProperties props = project == null ? null : (ProjectProperties)project.getLookup().lookup(ProjectProperties.class);
        List libs = props == null ? List.of() : props.getLibraries();
        SaveAsTemplateWizard wizard = new SaveAsTemplateWizard(this.rootDOB.getPrimaryFile().getName(), libs);
        if (wizard.display() == WizardDescriptor.FINISH_OPTION) {
            FileObject destination = wizard.getDestination();
            String filename = wizard.getFileName();
            PArray exportLibs = wizard.getExportLibraries();
            PXRRootProxy active = PXRRootRegistry.findRootForFile(this.rootDOB.getPrimaryFile());
            if (active != null) {
                Task.run((Task)SaveTask.createSaveTask(Set.of(this.rootDOB))).thenRunAsync(() -> this.copyTemplate(destination, filename, exportLibs), (Executor)RP);
            } else {
                RP.execute(() -> this.copyTemplate(destination, filename, exportLibs));
            }
        }
    }

    private void copyTemplate(FileObject destination, String filename, PArray libs) {
        try {
            Object templateContents = this.rootDOB.getPrimaryFile().asText();
            if (!libs.isEmpty()) {
                templateContents = "libraries " + SyntaxUtils.valueToToken((Value)libs) + "\n\n" + (String)templateContents;
            }
            FileObject template = FileUtil.createData((FileObject)destination, (String)filename);
            try (OutputStreamWriter writer = new OutputStreamWriter(template.getOutputStream());){
                writer.append((CharSequence)templateContents);
            }
            template.setAttribute("template", (Object)true);
            template.setAttribute("displayName", (Object)template.getName());
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

