/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr;

import java.awt.Component;
import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PResource;
import org.praxislive.ide.pxr.SaveAsTemplateWizardPanel1;

final class SaveAsTemplateWizard {
    static final String TEMPLATES_PATH = "Templates/Roots";
    static final String KEY_DESTINATION = "folder";
    static final String KEY_FILE_NAME = "filename";
    static final String KEY_LIBRARIES = "libraries";
    private final PArray libs;
    private final String suggestedFileName;
    private FileObject destination;
    private String fileName;
    private boolean includeLibraries;

    SaveAsTemplateWizard(String suggestedFileName, List<URI> libs) {
        this.suggestedFileName = suggestedFileName;
        this.libs = (PArray)libs.stream().filter(lib -> lib.toString().startsWith("pkg:")).map(PResource::of).collect(PArray.collector());
    }

    Object display() {
        ArrayList<SaveAsTemplateWizardPanel1> panels = new ArrayList<SaveAsTemplateWizardPanel1>();
        panels.add(new SaveAsTemplateWizardPanel1(this));
        String[] steps = new String[panels.size()];
        for (int i = 0; i < panels.size(); ++i) {
            Component c = ((WizardDescriptor.Panel)panels.get(i)).getComponent();
            steps[i] = c.getName();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", true);
            jc.putClientProperty("WizardPanel_contentDisplayed", true);
            jc.putClientProperty("WizardPanel_contentNumbered", true);
        }
        WizardDescriptor wiz = new WizardDescriptor((WizardDescriptor.Iterator)new WizardDescriptor.ArrayIterator(panels));
        wiz.setTitleFormat(new MessageFormat("{0}"));
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)wiz);
        if (ret == WizardDescriptor.FINISH_OPTION) {
            this.destination = (FileObject)wiz.getProperty(KEY_DESTINATION);
            this.fileName = (String)wiz.getProperty(KEY_FILE_NAME);
            this.includeLibraries = (Boolean)wiz.getProperty(KEY_LIBRARIES);
        } else {
            this.destination = null;
            this.fileName = null;
            this.includeLibraries = false;
        }
        return ret;
    }

    FileObject getDestination() {
        return this.destination;
    }

    String getFileName() {
        return this.fileName;
    }

    PArray getExportLibraries() {
        return this.includeLibraries ? this.libs : PArray.EMPTY;
    }

    String getSuggestedFileName() {
        return this.suggestedFileName;
    }

    boolean hasLibraries() {
        return !this.libs.isEmpty();
    }

    boolean mightUseLibraries() {
        return this.hasLibraries();
    }

    FileObject getDefaultDestination() {
        try {
            return FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)TEMPLATES_PATH);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return FileUtil.toFileObject((File)new File(System.getProperty("user.home")));
        }
    }
}

