/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.editors;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableModel;
import org.openide.util.Exceptions;
import org.praxislive.core.ValueFormatException;
import org.praxislive.core.types.PMap;

class MapTable
extends JTable {
    private static final MapTransferHandler TRANSFER_HANDLER = new MapTransferHandler();

    public MapTable() {
        super(1, 2);
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setSurrendersFocusOnKeystroke(true);
        this.setTransferHandler(TRANSFER_HANDLER);
        this.setTableHeader(null);
        this.setShowGrid(true);
        this.initActions();
    }

    private void initActions() {
        Action[] actions = new Action[]{new DeleteAction()};
        InputMap im = this.getInputMap();
        ActionMap am = this.getActionMap();
        for (Action action : actions) {
            String name = (String)action.getValue("Name");
            im.put((KeyStroke)action.getValue("AcceleratorKey"), name);
            am.put(name, action);
        }
        am.put("copy-to-clipboard", new RedirectAction(this, TransferHandler.getCopyAction()));
        am.put("paste-from-clipboard", new RedirectAction(this, TransferHandler.getPasteAction()));
        this.wrapTab();
    }

    private void wrapTab() {
        Object key = this.getInputMap(1).get(KeyStroke.getKeyStroke(9, 0));
        Action action = this.getActionMap().get(key);
        if (action != null) {
            this.getActionMap().put(key, new NextCellAction(action));
        }
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        if (e instanceof KeyEvent && this.suppressKeyEvent((KeyEvent)e)) {
            return false;
        }
        return super.editCellAt(row, column, e);
    }

    private boolean suppressKeyEvent(KeyEvent ke) {
        int mask = 384;
        return (ke.getModifiersEx() & mask) != 0;
    }

    private static class MapTransferHandler
    extends TransferHandler {
        private MapTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof MapTable) {
                MapTable table = (MapTable)c;
                int row = table.getSelectedRow();
                int rowCount = table.getSelectedRowCount();
                if (row < 0 || rowCount < 1) {
                    return null;
                }
                PMap.Builder mapBldr = PMap.builder();
                for (int i = 0; i < rowCount; ++i) {
                    String ks;
                    Object k = table.getValueAt(row + i, 0);
                    Object v = table.getValueAt(row + i, 1);
                    if (k == null || (ks = k.toString()).isEmpty()) continue;
                    mapBldr.put(ks, v);
                }
                return new StringSelection(mapBldr.build().toString());
            }
            return null;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDataFlavorSupported(DataFlavor.stringFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (support.getComponent() instanceof MapTable && this.canImport(support)) {
                try {
                    int rd;
                    MapTable table = (MapTable)support.getComponent();
                    int row = table.getSelectedRow();
                    int rowCount = table.getSelectedRowCount();
                    if (row < 0 || rowCount != 1) {
                        return false;
                    }
                    String data = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    PMap map = PMap.parse((String)data);
                    List keys = map.keys();
                    for (int r = 0; r < keys.size() && (rd = r + row) < table.getRowCount(); ++r) {
                        String key = (String)keys.get(r);
                        table.setValueAt(key, rd, 0);
                        table.setValueAt(map.getString(key, ""), rd, 1);
                    }
                }
                catch (UnsupportedFlavorException | IOException | ValueFormatException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return false;
        }
    }

    private class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super("delete");
            this.putValue("ShortDescription", "Delete");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MapTable.this.getSelectedRow();
            int rowCount = MapTable.this.getSelectedRowCount();
            if (row < 0 || rowCount < 1) {
                return;
            }
            for (int r = row + rowCount - 1; r >= row; --r) {
                ((DefaultTableModel)MapTable.this.getModel()).removeRow(r);
                MapTable.this.getSelectionModel().setSelectionInterval(r - 1, r - 1);
            }
        }
    }

    private class RedirectAction
    extends AbstractAction {
        private final MapTable table;
        private final Action action;

        private RedirectAction(MapTable table, Action action) {
            super("redirect-" + String.valueOf(action.getValue("Name")));
            this.table = table;
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            e = new ActionEvent(this.table, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers());
            this.action.actionPerformed(e);
        }
    }

    private class NextCellAction
    extends AbstractAction {
        private final Action wrapped;

        public NextCellAction(Action wrapped) {
            super("next-cell");
            this.wrapped = wrapped;
            this.putValue("ShortDescription", "Next Cell");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(9, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MapTable.this.getSelectedRow() + 1;
            if (row >= MapTable.this.getRowCount() && MapTable.this.getSelectedColumn() == 1) {
                ((DefaultTableModel)MapTable.this.getModel()).addRow(new Object[]{"", ""});
            }
            this.wrapped.actionPerformed(e);
        }
    }
}

