/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.praxislive.core.ArgumentInfo;
import org.praxislive.core.Value;
import org.praxislive.core.ValueFormatException;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PNumber;
import org.praxislive.ide.properties.EditorSupport;
import org.praxislive.ide.properties.PraxisProperty;
import org.praxislive.ide.pxr.editors.NumberInplaceEditor;

public class NumberEditor
extends EditorSupport
implements ExPropertyEditor,
InplaceEditor.Factory {
    private static final String EDIT_AS_TEXT = "canEditAsText";
    private final ArgumentInfo info;
    private NumberInplaceEditor inplace;
    private boolean isInteger;
    private List<String> suggested;

    public NumberEditor(PraxisProperty<?> property, ArgumentInfo info) {
        this.info = info;
        this.init();
    }

    private void init() {
        this.isInteger = this.info.properties().getBoolean("is-integer", false);
        if (this.isInteger) {
            this.initInt();
        } else {
            this.initFP();
        }
    }

    private void initFP() {
        PMap props = this.info.properties();
        double min = props.getDouble("minimum", -2.147483648E9);
        double max = props.getDouble("maximum", 2.147483647E9);
        if (min > -2.147483647E9 || max < 2.147483646E9) {
            double skew = props.getDouble("skew", 1.0);
            this.inplace = new NumberInplaceEditor(min, max, skew);
        }
    }

    private void initInt() {
        PMap props = this.info.properties();
        Value arg = props.get("suggested-values");
        int min = props.getInt("minimum", Integer.MIN_VALUE);
        int max = props.getInt("maximum", Integer.MIN_VALUE);
        if (arg != null) {
            try {
                PArray arr = (PArray)PArray.from((Value)arg).orElseThrow();
                this.suggested = new ArrayList<String>(arr.size());
                for (Value val : arr) {
                    this.suggested.add(val.toString());
                }
            }
            catch (Exception exception) {}
        } else if (max > min && (long)max - (long)min <= 16L) {
            this.suggested = IntStream.rangeClosed(min, max).mapToObj(String::valueOf).collect(Collectors.toList());
        }
    }

    public Object getAttribute(String key) {
        if (this.suggested != null && EDIT_AS_TEXT.equals(key)) {
            return Boolean.TRUE;
        }
        return null;
    }

    public String[] getAttributeKeys() {
        return new String[]{EDIT_AS_TEXT};
    }

    public void setAsText(String text) throws IllegalArgumentException {
        try {
            this.setValue(PNumber.parse((String)text));
        }
        catch (ValueFormatException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String getPraxisInitializationString() {
        return PNumber.from((Value)((Value)this.getValue())).map(PNumber::toString).orElse(null);
    }

    public String getDisplayName() {
        return "Number Editor";
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean isPaintable() {
        return this.inplace != null;
    }

    public void paintValue(Graphics g, Rectangle box) {
        double value = PNumber.from((Value)((Value)this.getValue())).orElse(PNumber.ZERO).value();
        this.inplace.paintValue(g, box, value, false);
    }

    public void attachEnv(PropertyEnv env) {
        if (this.inplace != null) {
            env.registerInplaceEditorFactory((InplaceEditor.Factory)this);
        }
    }

    public InplaceEditor getInplaceEditor() {
        return this.inplace;
    }

    public String[] getTags() {
        if (this.suggested != null) {
            return this.suggested.toArray(new String[this.suggested.size()]);
        }
        return null;
    }
}

