/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.editors;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.praxislive.core.Value;
import org.praxislive.core.types.PNumber;

class NumberInplaceEditor
extends JComponent
implements InplaceEditor {
    private static final Logger LOG = Logger.getLogger(NumberInplaceEditor.class.getName());
    private static final Color ACTIVE_COLOR = Color.WHITE;
    private static final Color INACTIVE_COLOR = Color.GRAY;
    private static final DecimalFormat FORMATTER = new DecimalFormat("####0.0####");
    private static final long IGNORE_CLICK_TIME = 500000000L;
    private PropertyEditor propertyEditor;
    private PropertyModel propertyModel;
    private final List<ActionListener> listeners;
    private JTextField textField;
    private Object initialValue;
    private PNumber currentValue;
    private final double min;
    private final double max;
    private final double skew;

    NumberInplaceEditor(double min, double max, double skew) {
        this.min = min;
        this.max = max;
        this.skew = skew < 0.125 ? 0.125 : (skew > 8.0 ? 8.0 : skew);
        this.listeners = new ArrayList<ActionListener>();
        this.initThis();
        this.initComponents();
    }

    private void initThis() {
        this.setFocusable(true);
        this.setLayout(new GridLayout());
        MouseHandler handler = new MouseHandler();
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
    }

    private void initComponents() {
        this.textField = new JTextField();
        this.textField.setVisible(false);
        this.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberInplaceEditor.this.fireActionEvent(true);
            }
        });
        this.add(this.textField);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.textField.isVisible()) {
            return;
        }
        Rectangle bounds = new Rectangle(3, 0, this.getWidth() - 3, this.getHeight());
        this.paintValue(g, bounds, this.currentValue.value(), true);
    }

    void paintValue(Graphics g, Rectangle box, double value, boolean highlight) {
        Color c = g.getColor();
        String stringValue = FORMATTER.format(value);
        double delta = (value - this.min) / (this.max - this.min);
        delta = Math.pow(delta, 1.0 / this.skew);
        int x = (int)(delta * (double)(box.width - 1));
        x += box.x;
        FontMetrics fm = g.getFontMetrics();
        if (!highlight) {
            g.setColor(INACTIVE_COLOR);
            g.drawLine(x, box.y, x, box.height);
            g.setColor(c);
            g.drawString(stringValue, box.x, box.y + (box.height - fm.getHeight()) / 2 + fm.getAscent());
        } else {
            g.setColor(INACTIVE_COLOR);
            g.drawString(stringValue, box.x, box.y + (box.height - fm.getHeight()) / 2 + fm.getAscent());
            g.setColor(ACTIVE_COLOR);
            g.drawLine(x, box.y, x, box.height);
            g.setColor(c);
        }
    }

    public void connect(PropertyEditor pe, PropertyEnv env) {
        this.propertyEditor = pe;
        this.initialValue = pe.getValue();
        this.textField.setVisible(false);
        AWTEvent event = EventQueue.getCurrentEvent();
        LOG.log(Level.FINE, "Invoking Event: {0}", event);
        if (event instanceof KeyEvent) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NumberInplaceEditor.this.focusTextField();
                }
            });
        }
        this.reset();
    }

    public JComponent getComponent() {
        return this;
    }

    public void clear() {
        this.propertyEditor = null;
        this.propertyModel = null;
    }

    public void setValue(Object o) {
        block3: {
            try {
                this.currentValue = PNumber.from((Value)((Value)o)).orElse(PNumber.ZERO);
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "Exception in setValue()", ex);
                if (this.currentValue != null) break block3;
                this.currentValue = PNumber.ZERO;
            }
        }
        if (this.textField.isVisible()) {
            this.textField.setText(this.currentValue.toString());
        }
    }

    public Object getValue() {
        if (this.textField.isVisible()) {
            try {
                return PNumber.parse((String)this.textField.getText());
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "Exception in getValue()", ex);
            }
        }
        return this.currentValue;
    }

    public boolean supportsTextEntry() {
        return true;
    }

    public void reset() {
        LOG.fine("Reset Called");
        this.setValue(this.initialValue);
    }

    public void addActionListener(ActionListener al) {
        this.listeners.add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.listeners.remove(al);
    }

    private void fireActionEvent(boolean success) {
        ActionEvent ev = new ActionEvent(this, 1001, success ? "success" : "failure");
        for (ActionListener l : this.listeners.toArray(new ActionListener[0])) {
            l.actionPerformed(ev);
        }
    }

    public KeyStroke[] getKeyStrokes() {
        return new KeyStroke[0];
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    public PropertyModel getPropertyModel() {
        return this.propertyModel;
    }

    public void setPropertyModel(PropertyModel pm) {
        this.propertyModel = pm;
    }

    public boolean isKnownComponent(Component c) {
        return c == this || c == this.textField;
    }

    private void updateValue(double value) {
        this.currentValue = PNumber.of((double)value);
        try {
            this.propertyModel.setValue((Object)this.currentValue);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        this.repaint();
    }

    private void focusTextField() {
        this.textField.setText(this.currentValue.toString());
        this.textField.setVisible(true);
        this.textField.selectAll();
        this.textField.requestFocusInWindow();
    }

    private class MouseHandler
    extends MouseAdapter {
        private int startX;
        private int valueX;
        private boolean dragging;
        private long clickTime;

        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (NumberInplaceEditor.this.textField.isVisible()) {
                return;
            }
            this.clickTime = System.nanoTime();
            this.startX = me.getX();
            double delta = (NumberInplaceEditor.this.currentValue.value() - NumberInplaceEditor.this.min) / (NumberInplaceEditor.this.max - NumberInplaceEditor.this.min);
            delta = Math.pow(delta, 1.0 / NumberInplaceEditor.this.skew);
            this.valueX = (int)(delta * (double)NumberInplaceEditor.this.getWidth() + 0.5);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (this.dragging) {
                this.dragging = false;
                this.update(me);
                NumberInplaceEditor.this.fireActionEvent(true);
            } else if (System.nanoTime() - this.clickTime < 500000000L) {
                NumberInplaceEditor.this.focusTextField();
            } else {
                NumberInplaceEditor.this.fireActionEvent(false);
            }
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            this.dragging = true;
            this.update(me);
        }

        private void update(MouseEvent me) {
            int curX = this.valueX + (me.getX() - this.startX);
            double delta = (double)curX / (double)NumberInplaceEditor.this.getWidth();
            delta = delta < 0.0 ? 0.0 : (delta > 1.0 ? 1.0 : delta);
            delta = Math.pow(delta, NumberInplaceEditor.this.skew);
            delta = delta * (NumberInplaceEditor.this.max - NumberInplaceEditor.this.min) + NumberInplaceEditor.this.min;
            NumberInplaceEditor.this.updateValue(delta);
        }
    }
}

