/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxs;

import java.io.IOException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.praxislive.ide.pxs.PXSHelper;
import org.praxislive.ide.pxs.RunScriptCookie;

public class PXSDataObject
extends MultiDataObject {
    public PXSDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
        CookieSet cookies = this.getCookieSet();
        cookies.add((Node.Cookie)DataEditorSupport.create((DataObject)this, (MultiDataObject.Entry)this.getPrimaryEntry(), (CookieSet)cookies));
        cookies.add((Node.Cookie)new RunScriptImpl());
    }

    protected Node createNodeDelegate() {
        return new DataNode((DataObject)this, Children.LEAF, this.getLookup());
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    private class RunScriptImpl
    implements RunScriptCookie,
    Node.Cookie {
        private RunScriptImpl() {
        }

        @Override
        public void runScript() {
            try {
                FileObject file = PXSDataObject.this.getPrimaryFile();
                Project project = FileOwnerQuery.getOwner((FileObject)file);
                PXSHelper helper = (PXSHelper)((Object)project.getLookup().lookup(PXSHelper.class));
                Object script = file.asText();
                script = "set _PWD " + String.valueOf(file.toURI()) + "\n" + (String)script;
                helper.executeScript((String)script);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

