/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.tableeditor;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.praxislive.ide.tableeditor.Bundle;
import org.praxislive.ide.tableeditor.PraxisTable;
import org.praxislive.ide.tableeditor.PraxisTableModel;
import org.praxislive.ide.tableeditor.PraxisTableModels;
import org.praxislive.ide.tableeditor.TableDataObject;

@TopComponent.Description(preferredID="TableEditor", persistenceType=2)
public final class TableEditorTopComponent
extends TopComponent {
    private static final String RESOURCE_DIR = "org/praxislive/ide/tableeditor/resources/";
    private final TableDataObject dob;
    private final Listener listener;
    private PraxisTableModels tableModels;
    private PraxisTable table;
    private JComboBox<String> tableSelect;
    private JSpinner rowSpinner;
    private JSpinner columnSpinner;
    private JButton addButton;
    private JButton removeButton;
    private boolean modified;

    TableEditorTopComponent(TableDataObject dob) {
        this.dob = dob;
        this.setDisplayName(dob.getPrimaryFile().getName());
        this.associateLookup((Lookup)new ProxyLookup(new Lookup[]{dob.getLookup(), Lookups.singleton((Object)this.getActionMap())}));
        this.setLayout(new BorderLayout());
        this.listener = new Listener();
        this.tableModels = new PraxisTableModels();
        this.initTable();
        this.initTopToolbar();
        this.initBottomToolbar();
        this.updateTableModels(this.tableModels);
    }

    private void initTable() {
        this.table = new PraxisTable();
        this.add(new JScrollPane(this.table), "Center");
        this.getActionMap().setParent(this.table.getActionMap());
    }

    private void initTopToolbar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        this.tableSelect = new JComboBox();
        this.tableSelect.addActionListener(this.listener);
        toolbar.add(this.tableSelect);
        toolbar.addSeparator();
        this.removeButton = new JButton(ImageUtilities.loadImageIcon((String)"org/praxislive/ide/tableeditor/resources/delete.png", (boolean)true));
        this.removeButton.addActionListener(this.listener);
        this.addButton = new JButton(ImageUtilities.loadImageIcon((String)"org/praxislive/ide/tableeditor/resources/add.png", (boolean)true));
        this.addButton.addActionListener(this.listener);
        toolbar.add(this.removeButton);
        toolbar.add(this.addButton);
        toolbar.addSeparator();
        this.add(toolbar, "North");
    }

    private void initBottomToolbar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        this.rowSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 512, 1));
        this.rowSpinner.addChangeListener(this.listener);
        this.columnSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 32, 1));
        this.columnSpinner.addChangeListener(this.listener);
        toolbar.add(new JLabel(Bundle.label_rows()));
        toolbar.addSeparator();
        toolbar.add(this.rowSpinner);
        toolbar.addSeparator();
        toolbar.add(new JLabel(Bundle.label_columns()));
        toolbar.addSeparator();
        toolbar.add(this.columnSpinner);
        this.add(toolbar, "South");
    }

    protected void componentClosed() {
        super.componentClosed();
        this.dob.editorClosed(this);
    }

    public boolean canClose() {
        if (this.modified) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)Bundle.dialog_close_message(), Bundle.dialog_close_title(), 0);
            if (!NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
                return false;
            }
        }
        return super.canClose();
    }

    void updateTableModels(PraxisTableModels models) {
        this.listener.ignore = true;
        this.tableModels = models;
        if (models.size() == 0) {
            models.add(new PraxisTableModel(16, 4));
        }
        this.configurePatternSelect();
        this.table.setModel(models.get(0));
        this.configureDimensions();
        this.listener.ignore = false;
    }

    void finishEditing() {
        if (this.table.isEditing() && !this.table.getCellEditor().stopCellEditing()) {
            this.table.getCellEditor().cancelCellEditing();
        }
    }

    private void configurePatternSelect() {
        this.tableSelect.removeAllItems();
        for (int i = 0; i < this.tableModels.size(); ++i) {
            this.tableSelect.addItem(Bundle.label_table() + " : " + i);
        }
        this.tableSelect.setSelectedIndex(0);
    }

    private void addTable() {
        PraxisTableModel model = new PraxisTableModel(16, 4);
        this.tableModels.add(model);
        this.tableSelect.addItem(Bundle.label_table() + " : " + this.tableSelect.getItemCount());
        this.tableSelect.setSelectedIndex(this.tableSelect.getItemCount() - 1);
        this.table.setModel(model);
        this.configureDimensions();
    }

    private void removeTable() {
        int count = this.tableModels.size();
        if (count < 2) {
            return;
        }
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)Bundle.dialog_delete_message(), Bundle.dialog_delete_title(), 0);
        if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
            PraxisTableModel model = this.tableModels.remove(count - 1);
            this.tableSelect.removeItemAt(this.tableSelect.getItemCount() - 1);
            if (model == this.table.getModel()) {
                this.tableSelect.setSelectedIndex(0);
                this.table.setModel(this.tableModels.get(0));
                this.configureDimensions();
            }
        }
    }

    private void configureDimensions() {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        this.rowSpinner.setValue(model.getRowCount());
        this.columnSpinner.setValue(model.getColumnCount());
    }

    void setModified(boolean modified) {
        if (this.modified == modified) {
            return;
        }
        this.modified = modified;
        if (modified) {
            this.setHtmlDisplayName("<html><b>" + this.dob.getPrimaryFile().getName() + "</b>");
        } else {
            this.setHtmlDisplayName(null);
        }
    }

    private class Listener
    implements ActionListener,
    ChangeListener {
        private boolean ignore;

        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.ignore) {
                return;
            }
            this.ignore = true;
            Object source = e.getSource();
            if (source == TableEditorTopComponent.this.tableSelect) {
                int p = TableEditorTopComponent.this.tableSelect.getSelectedIndex();
                if (p >= 0 && p < TableEditorTopComponent.this.tableModels.size()) {
                    TableEditorTopComponent.this.table.setModel(TableEditorTopComponent.this.tableModels.get(p));
                    TableEditorTopComponent.this.configureDimensions();
                }
            } else if (source == TableEditorTopComponent.this.addButton) {
                TableEditorTopComponent.this.addTable();
            } else if (source == TableEditorTopComponent.this.removeButton) {
                TableEditorTopComponent.this.removeTable();
            }
            this.ignore = false;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.ignore) {
                return;
            }
            this.ignore = true;
            DefaultTableModel model = (DefaultTableModel)TableEditorTopComponent.this.table.getModel();
            if (e.getSource() == TableEditorTopComponent.this.rowSpinner) {
                model.setRowCount((Integer)TableEditorTopComponent.this.rowSpinner.getValue());
            } else if (e.getSource() == TableEditorTopComponent.this.columnSpinner) {
                model.setColumnCount((Integer)TableEditorTopComponent.this.columnSpinner.getValue());
            }
            this.ignore = false;
        }
    }
}

