/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.tableeditor;

import java.util.ArrayList;
import org.praxislive.core.ValueFormatException;
import org.praxislive.core.syntax.Token;
import org.praxislive.core.syntax.Tokenizer;
import org.praxislive.ide.tableeditor.PraxisTableModel;
import org.praxislive.ide.tableeditor.PraxisTableModels;

class TableUtils {
    TableUtils() {
    }

    static PraxisTableModels parse(String data) throws ValueFormatException {
        PraxisTableModels models = new PraxisTableModels();
        ArrayList<String> row = new ArrayList<String>();
        PraxisTableModel model = null;
        int maxColumn = 0;
        int column = 0;
        Tokenizer tk = new Tokenizer((CharSequence)data);
        block5: for (Token t : tk) {
            Token.Type type = t.getType();
            switch (type) {
                case PLAIN: 
                case QUOTED: 
                case BRACED: {
                    if (maxColumn > 0 && column >= maxColumn) {
                        throw new ValueFormatException();
                    }
                    row.add(type == Token.Type.PLAIN ? TableUtils.parsePlainToken(t.getText()) : t.getText());
                    ++column;
                    continue block5;
                }
                case EOL: {
                    if (column > 0) {
                        if (model == null) {
                            model = new PraxisTableModel();
                            model.setColumnCount(column);
                            maxColumn = column;
                        } else {
                            while (column < maxColumn) {
                                row.add(null);
                                ++column;
                            }
                        }
                        model.addRow(row.toArray());
                        row.clear();
                        column = 0;
                        continue block5;
                    }
                    if (model == null) continue block5;
                    models.add(model);
                    model = null;
                    maxColumn = 0;
                    continue block5;
                }
                case COMMENT: {
                    continue block5;
                }
            }
            throw new ValueFormatException();
        }
        if (model != null) {
            models.add(model);
        }
        return models;
    }

    static String write(PraxisTableModels data) {
        StringBuilder sb = new StringBuilder();
        TableUtils.write(data, sb);
        return sb.toString();
    }

    static void write(PraxisTableModels data, StringBuilder sb) {
        boolean first = true;
        for (PraxisTableModel table : data) {
            if (!first) {
                sb.append('\n');
            }
            TableUtils.write(table, sb);
            first = false;
        }
    }

    static void write(PraxisTableModel data, StringBuilder sb) {
        TableUtils.write(data, sb, 0, 0, data.getRowCount(), data.getColumnCount());
    }

    static void write(PraxisTableModel data, StringBuilder sb, int rowOffset, int columnOffset, int rows, int columns) {
        for (int r = 0; r < rows; ++r) {
            if (TableUtils.isEmpty(data, rowOffset + r, columnOffset, columnOffset + columns)) {
                sb.append('.');
                sb.append('\n');
                continue;
            }
            boolean first = true;
            for (int c = 0; c < columns; ++c) {
                Object obj = data.getValueAt(rowOffset + r, columnOffset + c);
                if (!first) {
                    sb.append(' ');
                }
                sb.append(TableUtils.writeValue(obj));
                first = false;
            }
            sb.append('\n');
        }
    }

    private static String parsePlainToken(String token) {
        if (".".equals(token)) {
            return null;
        }
        return token;
    }

    private static String writeValue(Object value) {
        if (value == null) {
            return ".";
        }
        return TableUtils.escape(value.toString());
    }

    private static boolean isEmpty(PraxisTableModel data, int row, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (data.getValueAt(row, i) == null) continue;
            return false;
        }
        return true;
    }

    private static String escape(String input) {
        String res = TableUtils.escapePlain(input);
        if (res == null) {
            res = TableUtils.escapeQuoted(input);
        }
        return res;
    }

    private static String escapePlain(String input) {
        int len = input.length();
        if (len == 0) {
            return null;
        }
        if (input.startsWith(".") || input.startsWith("#")) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == '_' || c == '#') continue;
            return null;
        }
        return input;
    }

    private static String escapeQuoted(String input) {
        int len = input.length();
        if (len == 0) {
            return "\"\"";
        }
        StringBuilder sb = new StringBuilder(len * 2);
        sb.append("\"");
        block8: for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    sb.append('\\');
                    sb.append(c);
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }
}

