/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.tableeditor;

import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import org.openide.util.Exceptions;
import org.praxislive.core.ValueFormatException;
import org.praxislive.ide.tableeditor.PraxisTableModel;
import org.praxislive.ide.tableeditor.PraxisTableModels;
import org.praxislive.ide.tableeditor.TableUtils;

class PraxisTable
extends JTable {
    private static final TableTransferHandler TRANSFER_HANDLER = new TableTransferHandler();

    public PraxisTable() {
        this.getTableHeader().setReorderingAllowed(false);
        this.setCellSelectionEnabled(true);
        this.setSurrendersFocusOnKeystroke(true);
        this.setTransferHandler(TRANSFER_HANDLER);
        this.setShowGrid(true);
        this.initActions();
    }

    private void initActions() {
        Action[] actions = new Action[]{new DeleteAction()};
        InputMap im = this.getInputMap();
        ActionMap am = this.getActionMap();
        for (Action action : actions) {
            String name = (String)action.getValue("Name");
            im.put((KeyStroke)action.getValue("AcceleratorKey"), name);
            am.put(name, action);
        }
        am.put("copy-to-clipboard", new RedirectAction(this, TransferHandler.getCopyAction()));
        am.put("paste-from-clipboard", new RedirectAction(this, TransferHandler.getPasteAction()));
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        if (e instanceof KeyEvent && this.suppressKeyEvent((KeyEvent)e)) {
            return false;
        }
        return super.editCellAt(row, column, e);
    }

    private boolean suppressKeyEvent(KeyEvent ke) {
        int mask = 384;
        return (ke.getModifiersEx() & mask) != 0;
    }

    private static class TableTransferHandler
    extends TransferHandler {
        private TableTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof PraxisTable) {
                PraxisTable table = (PraxisTable)c;
                int row = table.getSelectedRow();
                int rowCount = table.getSelectedRowCount();
                int column = table.getSelectedColumn();
                int columnCount = table.getSelectedColumnCount();
                if (row < 0 || column < 0 || rowCount < 1 || columnCount < 1) {
                    return null;
                }
                PraxisTableModel model = (PraxisTableModel)table.getModel();
                StringBuilder sb = new StringBuilder();
                TableUtils.write(model, sb, row, column, rowCount, columnCount);
                return new StringSelection(sb.toString());
            }
            return null;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDataFlavorSupported(DataFlavor.stringFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (support.getComponent() instanceof PraxisTable && this.canImport(support)) {
                try {
                    int rd;
                    PraxisTable table = (PraxisTable)support.getComponent();
                    int row = table.getSelectedRow();
                    int rowCount = table.getSelectedRowCount();
                    int column = table.getSelectedColumn();
                    int columnCount = table.getSelectedColumnCount();
                    if (row < 0 || column < 0 || rowCount != 1 || columnCount != 1) {
                        return false;
                    }
                    String data = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    PraxisTableModels models = TableUtils.parse(data);
                    if (models.size() != 1) {
                        return false;
                    }
                    PraxisTableModel model = models.get(0);
                    for (int r = 0; r < model.getRowCount() && (rd = r + row) < table.getRowCount(); ++r) {
                        int cd;
                        for (int c = 0; c < model.getColumnCount() && (cd = c + column) < table.getColumnCount(); ++c) {
                            Object value = model.getValueAt(r, c);
                            table.setValueAt(value, rd, cd);
                        }
                    }
                }
                catch (UnsupportedFlavorException | IOException | ValueFormatException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return false;
        }
    }

    private class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super("delete");
            this.putValue("ShortDescription", "Delete");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        }

        @Override
        public void actionPerformed(final ActionEvent e) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DeleteAction.this.actionPerformed(e);
                    }
                });
                return;
            }
            int row = PraxisTable.this.getSelectedRow();
            int rowCount = PraxisTable.this.getSelectedRowCount();
            int column = PraxisTable.this.getSelectedColumn();
            int columnCount = PraxisTable.this.getSelectedColumnCount();
            if (row < 0 || column < 0 || rowCount < 1 || columnCount < 1) {
                return;
            }
            for (int r = row; r < row + rowCount; ++r) {
                for (int c = column; c < column + columnCount; ++c) {
                    PraxisTable.this.setValueAt(null, r, c);
                }
            }
        }
    }

    private class RedirectAction
    extends AbstractAction {
        private final PraxisTable table;
        private final Action action;

        private RedirectAction(PraxisTable table, Action action) {
            super("redirect-" + String.valueOf(action.getValue("Name")));
            this.table = table;
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            e = new ActionEvent(this.table, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers());
            this.action.actionPerformed(e);
        }
    }
}

