/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.tableeditor;

import java.awt.EventQueue;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.praxislive.core.ValueFormatException;
import org.praxislive.ide.tableeditor.PraxisTableModels;
import org.praxislive.ide.tableeditor.TableEditorTopComponent;
import org.praxislive.ide.tableeditor.TableUtils;

public class TableDataObject
extends MultiDataObject {
    private static final RequestProcessor RP = new RequestProcessor();
    private final PatternsListener patternsListener;
    private final Saver saver;
    private TableEditorTopComponent editor;
    private PraxisTableModels patterns;

    public TableDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
        CookieSet cookies = this.getCookieSet();
        cookies.add((Node.Cookie)new Opener());
        this.patternsListener = new PatternsListener();
        this.saver = new Saver();
    }

    protected int associateLookup() {
        return 1;
    }

    public void setModified(boolean modified) {
        assert (EventQueue.isDispatchThread());
        if (this.isModified() == modified) {
            return;
        }
        super.setModified(modified);
        if (this.isValid()) {
            if (modified) {
                this.getCookieSet().add((Node.Cookie)this.saver);
            } else {
                this.getCookieSet().remove((Node.Cookie)this.saver);
            }
            if (this.editor != null) {
                this.editor.setModified(modified);
            }
        }
    }

    protected void dispose() {
        assert (EventQueue.isDispatchThread());
        super.dispose();
        if (this.editor != null) {
            TableEditorTopComponent ed = this.editor;
            this.editor = null;
            ed.setModified(false);
            ed.close();
        }
    }

    void editorClosed(TableEditorTopComponent editor) {
        if (this.editor == editor) {
            this.editor = null;
            this.updatePatterns(null);
        }
    }

    private void createEditor() {
        this.editor = new TableEditorTopComponent(this);
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    String data = TableDataObject.this.getPrimaryFile().asText();
                    final PraxisTableModels patterns = TableUtils.parse(data);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TableDataObject.this.updatePatterns(patterns);
                        }
                    });
                }
                catch (IOException | ValueFormatException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private void updatePatterns(PraxisTableModels patterns) {
        if (this.patterns != null) {
            this.patterns.removeChangeListener(this.patternsListener);
            this.patterns = null;
        }
        this.setModified(false);
        if (patterns != null && this.editor != null) {
            this.patterns = patterns;
            patterns.addChangeListener(this.patternsListener);
            this.editor.updateTableModels(patterns);
        }
    }

    private class Opener
    implements OpenCookie {
        private Opener() {
        }

        public void open() {
            if (TableDataObject.this.editor == null) {
                TableDataObject.this.createEditor();
            }
            TableDataObject.this.editor.open();
            TableDataObject.this.editor.requestActive();
        }
    }

    private class PatternsListener
    implements ChangeListener {
        private PatternsListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            TableDataObject.this.setModified(true);
        }
    }

    private class Saver
    implements SaveCookie {
        private Saver() {
        }

        public void save() throws IOException {
            assert (EventQueue.isDispatchThread());
            if (TableDataObject.this.editor != null) {
                TableDataObject.this.editor.finishEditing();
            }
            TableDataObject.this.setModified(false);
            final String data = TableUtils.write(TableDataObject.this.patterns);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    Writer writer = null;
                    try {
                        FileObject file = TableDataObject.this.getPrimaryFile();
                        writer = new OutputStreamWriter(file.getOutputStream());
                        writer.append(data);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                }
            });
        }
    }
}

